<x-app-layout>
    @section('title', 'Infografías: Subir')
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Subir Infografías') }}
        </h2>
    </x-slot>
    <div class="container bg-white">
        <div class="form-container py-3">
            <div class="form-header py-3">
                <h2>Subir Infografía</h2>
            </div>
            <form action="{{ route('panel-infografias.store') }}" method="POST" enctype="multipart/form-data" novalidate>
                @csrf
                <div class="mb-3">
                    <div class="row">
                        <div class="col-md-8 my-2">
                            <div class="custom-section-title"><i class="fa-solid fa-file-signature"></i> Nombre de la
                                infografía: *
                            </div>
                            <input name="nombre" type="text" id="fname" placeholder="Infografía del día de..."
                                class="form-control @error('nombre') is-invalid @enderror" value="{{ old('nombre') }}"
                                @error('nombre') autofocus @enderror required>
                            @error('nombre')
                                <div class="invalid-feedback">
                                    <strong>{{ $message }}</strong>
                                </div>
                            @enderror
                        </div>
                        <div class="col-md-4 my-2">
                            <div class="custom-section-title"><i class="fa-solid fa-calendar-check"></i>
                                Fecha de publicación: *
                            </div>
                            <input type="date" id="fecha_publicacion" name="fecha_publicacion"
                                title="Formato válido: YYYY o YYYY-YYYY"
                                class="form-control @error('fecha_publicacion') is-invalid @enderror"
                                value="{{ old('fecha_publicacion') }}" @error('fecha_publicacion') autofocus @enderror
                                required>
                            @error('fecha_publicacion')
                                <div class="invalid-feedback">
                                    <strong>{{ $message }}</strong>
                                </div>
                            @enderror
                        </div>
                    </div>
                    <div class="my-2">
                        <div class="custom-section-title"><i class="fa-regular fa-image"></i> Subir
                            miniatura*
                        </div>
                        <div class="input-group">
                            <input accept=".jpg,.png,.svg,.jpeg" name="miniatura" id="miniatura" type="file"
                                class="form-control @error('miniatura') is-invalid @enderror"
                                @error('miniatura') autofocus @enderror required>
                            @error('miniatura')
                                <div class="invalid-feedback">
                                    <strong>{{ $message }}</strong>
                                </div>
                            @enderror
                        </div>
                    </div>
                    <div class="mb-3 text-center">
                        <img id="miniaturaSeleccionada" class="img-fluid" style="max-height: 300px;"
                            alt="Miniatura seleccionada">
                    </div>
                    <div class="mb-3">
                        <div class="custom-section-title"><i class="fa-regular fa-image"></i>
                            Subir infografía: *
                        </div>
                        <div class="input-group">
                            <input accept=".jpg,.png,.svg,.jpeg" name="infografia" id="infografia" type="file"
                                class="form-control @error('infografia') is-invalid @enderror"
                                @error('infografia') autofocus @enderror required>
                            @error('infografia')
                                <div class="invalid-feedback">
                                    <strong>{{ $message }}</strong>
                                </div>
                            @enderror
                        </div>
                    </div>
                    <div class="mb-3 text-center">
                        <img id="infografiaSeleccionada" class="img-fluid" style="max-height: 300px;"
                            alt="Infografía seleccionada">
                    </div>
                    <div class="d-flex justify-content-between">
                        <a href="{{ route('panel-infografias.index') }}" class="btn btn-secondary w-100">Cancelar</a>
                        <button type="submit" class="btn btn-success w-100">Subir</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</x-app-layout>

<script>
    $(document).ready(function(e) {
        $('#miniatura').change(function() {
            let reader = new FileReader();
            reader.onload = (e) => {
                $('#miniaturaSeleccionada').attr('src', e.target.result);
            }
            reader.readAsDataURL(this.files[0]);
        });
    });
    $(document).ready(function(e) {
        $('#infografia').change(function() {
            let reader = new FileReader();
            reader.onload = (e) => {
                $('#infografiaSeleccionada').attr('src', e.target.result);
            }
            reader.readAsDataURL(this.files[0]);
        });
    });
</script>
