<x-app-layout>
    @section('title', 'Fotografías: Inicio')
    <x-slot name="header">
        <h2 class="h5 text-dark">
            {{ __('Fotografías del Comité') }}
        </h2>
    </x-slot>

    @if ($message = Session::get('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ $message }}'
            })
        </script>
    @endif

    <div class="container">
        <div class="bg-white shadow p-4 rounded table-responsive">
            <div class="mb-3">
                @can('crear-fotografia')
                    <a href="{{ route('panel-fotografias.create') }}">
                        <button class="btn btn-primary">
                            Subir fotos
                        </button>
                    </a>
                @endcan
            </div>
            <table id="myTable" class="table table-striped table-bordered" style="width:100%">
                <thead>
                    <tr>
                        <th>Evento</th>
                        <th>Mes</th>
                        <th>Año</th>
                        <th>Foto</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    @if ($fotografias)
                        @foreach ($fotografias as $foto)
                            <tr>
                                <td>{{ $foto->nombre_evento }}</td>
                                <td>{{ \Carbon\Carbon::parse($foto->fecha)->locale('es')->translatedFormat('F') }}</td>
                                <td>{{ \Carbon\Carbon::parse($foto->fecha)->format('Y') }}</td>
                                <td>
                                    @php
                                        $extension = pathinfo($foto->nombre_archivo, PATHINFO_EXTENSION);
                                        $extensionesImagen = ['jpeg', 'jpg', 'png', 'svg'];
                                        $extensionesVideo = ['mp4', 'mov', 'avi', 'wmv'];
                                    @endphp

                                    @if (in_array($extension, $extensionesImagen))
                                        <a href="imagenes/fotos-carpeta/{{ $foto->nombre_archivo }}" target="_blank"
                                            rel="noopener">
                                            <img src="imagenes/fotos-carpeta/{{ $foto->nombre_archivo }}"
                                                class="img-thumbnail" style="max-height: 100px">
                                        </a>
                                    @elseif(in_array($extension, $extensionesVideo))
                                        <video controls style="max-height: 100px">
                                            <source src="imagenes/fotos-carpeta/{{ $foto->nombre_archivo }}"
                                                type="video/{{ $extension }}">
                                            Tu navegador no soporta la reproducción de videos.
                                        </video>
                                    @endif
                                </td>
                                {{-- <td>
                            <a href="imagenes/fotos-carpeta/{{ $foto->nombre_archivo }}" target="_blank"
                                rel="noopener">
                                <img src="imagenes/fotos-carpeta/{{ $foto->nombre_archivo }}"
                                    class="img-thumbnail" style="max-height: 100px">
                            </a>
                        </td> --}}
                                <td>
                                    <div class="d-flex justify-content-center gap-2">
                                        {{-- <a href="{{ route('panel-fotografias.edit', $foto->id) }}"
                                class="btn btn-secondary">Editar</a> --}}
                                        <!-- Botón para abrir el modal de edición -->
                                        @can('editar-fotografia')
                                            <button class="btn btn-secondary btnEditar" data-bs-toggle="modal"
                                                data-bs-target="#modalEditar" data-id="{{ $foto->id }}"
                                                data-nombre="{{ $foto->nombre_evento }}" data-fecha="{{ $foto->fecha }}"
                                                data-imagen="imagenes/fotos-carpeta/{{ $foto->nombre_archivo }}">
                                                Editar
                                            </button>
                                        @endcan
                                        @can('borrar-fotografia')
                                            <form action="{{ route('panel-fotografias.destroy', $foto->id) }}"
                                                method="POST" class="d-inline formEliminar">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger">Borrar</button>
                                            </form>
                                        @endcan
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @endif
                </tbody>
                <tfoot>
                    <tr>
                        <th>Evento</th>
                        <th>Mes</th>
                        <th>Año</th>
                        <th>Foto</th>
                        <th>Acciones</th>
                    </tr>
                </tfoot>
            </table>
            <div class="modal fade" id="modalEditar" tabindex="-1" aria-labelledby="modalEditarLabel"
                aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="modalEditarLabel">Editar Fotografía</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <form id="formEditar" action="{{ route('panel-fotografias.update', 0) }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="mb-3">
                                    <label for="nombre_evento" class="form-label">Nombre del evento</label>
                                    <input type="text" class="form-control" id="nombre_evento" name="nombre_evento"
                                        required>
                                </div>
                                <div class="mb-3">
                                    <label for="fecha" class="form-label">Fecha</label>
                                    <input type="date" class="form-control" id="fecha" name="fecha" required>
                                </div>
                                <div class="mb-3">
                                    <label for="imagen_actual" class="form-label">Imagen actual</label>
                                    <img id="imagen_actual" src="" class="img-fluid mb-3">
                                </div>
                                <div class="mb-3">
                                    <label for="nombre_archivo" class="form-label">Actualizar fotografía</label>
                                    <input type="file" class="form-control" id="nombre_archivo"
                                        name="nombre_archivo">
                                </div>
                                <button type="submit" class="btn btn-primary">Guardar cambios</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>

<!-- Scripts -->
<script>
    $(document).ready(function() {
        $('#myTable').DataTable({
            "pagingType": "simple_numbers",
            "order": [],
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ entradas",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "previous": "Anterior",
                    "next": "Siguiente"
                }
            }
        });
    });
</script>
<script>
    (function() {
        'use strict'
        //debemos crear la clase formEliminar dentro del form del boton borrar
        //recordar que cada registro a eliminar esta contenido en un form  
        var forms = document.querySelectorAll('.formEliminar')
        Array.prototype.slice.call(forms)
            .forEach(function(form) {
                form.addEventListener('submit', function(event) {
                    event.preventDefault()
                    event.stopPropagation()
                    Swal.fire({
                        title: '¿Confirma la eliminación del registro?',
                        icon: 'info',
                        showCancelButton: true,
                        confirmButtonColor: '#20c997',
                        cancelButtonColor: '#6c757d',
                        confirmButtonText: 'Confirmar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            this.submit();
                            Swal.fire('¡Eliminado!',
                                'El registro ha sido eliminado exitosamente.', 'success');
                        }
                    })
                }, false)
            })
    })()
</script>
<script>
    $(document).ready(function() {
        $('#modalEditar').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget); // Botón que activó el modal
            var id = button.data('id');
            var nombre = button.data('nombre');
            var fecha = button.data('fecha');
            var imagen = button.data('imagen');

            var modal = $(this);
            modal.find('.modal-title').text('Editar Fotografía: ' + nombre);
            modal.find('#nombre_evento').val(nombre);
            modal.find('#fecha').val(fecha);
            modal.find('#imagen_actual').attr('src', imagen);

            var formAction = "{{ url('panel-fotografias') }}/" + id;
            modal.find('#formEditar').attr('action', formAction);
        });
    });
</script>
