<x-app-layout>
    @section('title', 'Fotografías: Editar')
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Editar Información de Fotografías') }}
        </h2>
    </x-slot>

    <div class="container bg-white">
        <div class="form-container">
            <div class="form-header py-3">
                <h2>Editar fotografía</h2>
            </div>

            <form action="{{ route('panel-fotografias.update', $fotos->id) }}" method="POST"
                enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="container row">
                    <div class="col-md-8 my-2">
                        <div class="custom-section-title"><i class="fa-solid fa-file-signature"></i> Nombre del evento:
                            *
                        </div>
                        <input name="nombre_evento" value="{{ $fotos->nombre_evento }}" class="form-control"
                            type="text" id="nombre_evento" required>
                        @error('nombre_evento')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-4 my-2">
                        <div class="custom-section-title"><i class="fa-solid fa-calendar-check"></i>
                            Fecha: *
                        </div>
                        <input name="fecha" value="{{ $fotos->fecha }}" class="form-control" type="date"
                            id="fecha" required>
                        @error('fecha')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="container row">
                    <div class="col-md-8">
                        <div class="custom-section-title"><i class="fa-solid fa-image"></i>
                            Fotografía: *
                        </div>
                        <img src="/imagenes/fotos-carpeta/{{ $fotos->nombre_archivo }}" width="90%"
                            id="fotografiaSeleccionada" class="img-fluid">
                    </div>
                    <div class="col-md-4">
                        <div class="custom-section-title"><i class="fa-solid fa-image"></i>
                            Actualizar fotografía: *
                        </div>
                        <div class="text-center">
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="nombre_archivo"
                                    name="nombre_archivo">
                                <label class="custom-file-label" for="nombre_archivo">Seleccione la imagen</label>
                                @error('nombre_archivo')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
                <div class="d-flex justify-content-between my-4">
                    <a href="{{ route('panel-fotografias.index') }}" class="btn btn-secondary w-100">Cancelar</a>
                    <button type="submit" class="btn btn-primary w-100">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</x-app-layout>

<!-- Script para ver la imagen -->
{{-- <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script> --}}
<script>
    $(document).ready(function(e) {
        $('#nombre_archivo').change(function() {
            let reader = new FileReader();
            reader.onload = (e) => {
                $('#fotografiaSeleccionada').attr('src', e.target.result);
            }
            reader.readAsDataURL(this.files[0]);
        });
    });
</script>
