<x-app-layout>
    @section('title', 'Fotografías: Subir')
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Subir Fotografías') }}
        </h2>
    </x-slot>
    <script src="https://unpkg.com/dropzone@5/dist/min/dropzone.min.js"></script>
    <link rel="stylesheet" href="https://unpkg.com/dropzone@5/dist/min/dropzone.min.css" type="text/css" />

    <div class="container bg-white">
        <div class="form-container py-3">
            <div class="form-header py-3">
                <h2>Subir fotografías</h2>
            </div>
            <form id="dropzoneForm" action="{{ route('panel-fotografias.store') }}" method="POST"
                enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="nombre_evento" id="nombre_evento">
                <input type="hidden" name="fecha" id="fecha">

                <div class="mb-3">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="custom-section-title"><i class="fa-solid fa-file-signature"></i> Nombre del
                                evento: *
                            </div>
                            <input name="nombre_evento" type="text" id="eventName"
                                placeholder="Dia Internacional de..."
                                class="w-full border border-gray-300 rounded-md py-2 px-3 focus:outline-none focus:border-blue-700 form-control @error('nombre_evento') is-invalid @enderror"
                                value="{{ old('nombre_evento') }}" @error('nombre_evento') autofocus @enderror autofocus
                                required>
                            @error('nombre_evento')
                                <small class="invalid-feedback">
                                    <strong>{{ $message }}</strong>
                                </small>
                            @enderror
                        </div>
                        <div class="col-md-4">
                            <div class="custom-section-title"><i class="fa-solid fa-calendar-check"></i>
                                Fecha: *
                            </div>
                            <input type="date" id="eventDate" name="fecha" placeholder="Fecha del evento"
                                class="w-full border border-gray-300 rounded-md py-2 px-3 focus:outline-none focus:border-blue-700 form-control @error('fecha') is-invalid @enderror"
                                value="{{ old('fecha') }}" @error('fecha') autofocus @enderror autofocus required>
                            @error('fecha')
                                <small class="invalid-feedback">
                                    <strong>{{ $message }}</strong>
                                </small>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="mb-3">
                    <div class="custom-section-title"><i class="fa-solid fa-calendar-check"></i>
                        Subir fotografías: *
                    </div>
                    <div class="form-group">
                        <div id="my-dropzone" class="dropzone"></div>
                    </div>
                </div>

                <div class="d-flex justify-content-between">
                    <a href="{{ route('panel-fotografias.index') }}" class="btn btn-secondary my-3 mx-2 w-100">
                        Volver
                    </a>
                    <button type="submit" class="btn btn-success my-3 mx-2 w-100">Subir</button>
                </div>
            </form>
        </div>
    </div>
</x-app-layout>
<script>
    Dropzone.autoDiscover = false;

    const dropzone = new Dropzone("#my-dropzone", {
        url: "{{ route('panel-fotografias.store') }}",
        paramName: "nombre_archivo[]",
        maxFilesize: 50, // MB
        acceptedFiles: ".jpeg,.jpg,.png,.svg,.mp4,.avi,.mkv",
        addRemoveLinks: true,
        dictDefaultMessage: "Arrastra las imágenes o videos aquí o haz clic para seleccionar",
        autoProcessQueue: false, // Evita que Dropzone procese la cola automáticamente
        init: function() {
            // Configuración de Dropzone
            this.on("sending", function(file, xhr, formData) {
                formData.append("nombre_evento", document.getElementById('eventName').value);
                formData.append("fecha", document.getElementById('eventDate').value);
                formData.append("_token", "{{ csrf_token() }}"); // Añadir el token CSRF
            });

            this.on("success", function(file, response) {
                // Manejo de la respuesta del servidor aquí si es necesario
            });

            this.on("error", function(file, response) {
                // Manejo de errores aquí si es necesario
                console.error(response);
            });
        }
    });

    // Manejo del botón de "Subir"
    document.querySelector('button[type="submit"]').addEventListener('click', function(event) {
        event.preventDefault(); // Evita que el formulario se envíe de la manera tradicional

        // Verificar si los campos necesarios están llenos
        const nombreEvento = document.getElementById('eventName').value;
        const fecha = document.getElementById('eventDate').value;

        if (!nombreEvento || !fecha) {
            Swal.fire({
                icon: 'error',
                title: 'Campos incompletos',
                text: 'Por favor, complete todos los campos requeridos.',
                confirmButtonText: 'Aceptar'
            });
            return;
        }

        // Procesar la cola de Dropzone
        dropzone.processQueue();
    });
</script>

