<x-app-layout>
    @section('title', 'Eventos')
    <style>
        /* Estilos específicos para el formulario de eventos */

        .event-form-container h2 {
            font-size: 1.8em;
            color: #333;
            margin-bottom: 20px;
        }

        .event-form-container .form-group {
            margin-bottom: 15px;
        }

        .event-form-container .form-group label {
            display: block;
            font-weight: bold;
            margin-bottom: 5px;
            color: #666;
        }

        .event-form-container .form-control {
            width: 100%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            font-size: 1em;
            color: #333;
        }

        .event-form-container .form-control:focus {
            border-color: #007bff;
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
        }

        .event-form-container button[type="submit"],
        .event-form-container .btn-secondary {
            padding: 10px 20px;
            font-size: 1em;
            border: none;
            border-radius: 5px;
            color: #fff;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        .event-form-container button[type="submit"] {
            background-color: #007bff;
        }

        .event-form-container button[type="submit"]:hover {
            background-color: #0056b3;
        }

        .event-form-container .btn-secondary {
            background-color: #6c757d;
        }

        .event-form-container .btn-secondary:hover {
            background-color: #5a6268;
        }

        /* Estilos específicos para la tabla de eventos */
        .event-form-container .table {
            margin: 20px 0;
            width: 100%;
            border-collapse: collapse;
        }

        .event-form-container .table th,
        .event-form-container .table td {
            padding: 10px;
            border: 1px solid #ddd;
            text-align: left;
        }

        .event-form-container .table th {
            background-color: #007bff;
            color: #fff;
        }

        .event-form-container .table-striped tbody tr:nth-of-type(odd) {
            background-color: #f9f9f9;
        }

        /* Estilos responsivos */
        @media (max-width: 768px) {
            .event-form-container .container {
                padding: 15px;
            }

            .event-form-container h2 {
                font-size: 1.5em;
            }
        }
    </style>
    @if ($message = Session::get('success'))
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            Swal.fire({
                icon: 'success',
                title: '{{ $message }}'
            });
        });
    </script>
    @endif
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Eventos del Comité') }}
        </h2>
    </x-slot>
    <div class="container py-12 mx-auto">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="container mb-3 py-3 card event-form-container">
                <h2 class="my-3 mx-3">Crear/editar evento</h2>
                <div class="card-body">
                    <form
                        action="{{ isset($event) ? route('panel-eventos.update', $event->id) : route('panel-eventos.store') }}"
                        method="POST" novalidate>
                        @csrf
                        @if (isset($event))
                        @method('PUT')
                        @endif

                        <div class="form-group">
                            <label for="titulo">Título</label>
                            <input type="text" name="titulo" id="titulo" class="form-control"
                                value="{{ old('titulo', isset($event) ? $event->titulo : '') }}" required>
                            @error('titulo')
                            <small class="invalid-feedback d-block">
                                <strong>{{ $message }}</strong>
                            </small>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="descripcion">Descripción</label>
                            <textarea name="descripcion" id="descripcion" class="form-control" required>{{ old('descripcion', isset($event) ? $event->descripcion : '') }}</textarea>
                            @error('descripcion')
                            <small class="invalid-feedback d-block">
                                <strong>{{ $message }}</strong>
                            </small>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="fecha_evento">Fecha del Evento</label>
                            <input type="date" name="fecha_evento" id="fecha_evento" class="form-control"
                                value="{{ old('fecha_evento', isset($event) ? $event->fecha_evento : '') }}" required>
                            @error('fecha_evento')
                            <small class="invalid-feedback d-block">
                                <strong>{{ $message }}</strong>
                            </small>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="subtitulo">Horario</label>
                            <input type="text" name="subtitulo" id="subtitulo" class="form-control"
                                value="{{ old('subtitulo', isset($event) ? $event->subtitulo : '') }}">
                            @error('subtitulo')
                            <small class="invalid-feedback d-block">
                                <strong>{{ $message }}</strong>
                            </small>
                            @enderror
                        </div>
                        <button type="submit"
                            class="btn btn-primary">{{ isset($event) ? 'Actualizar' : 'Crear' }}</button>
                        @if (isset($event))
                        <a href="{{ route('panel-eventos.index') }}" class="btn btn-secondary">Cancelar</a>
                        @endif
                    </form>
                </div>
            </div>
            <div class="card">
                <div class="container py-3">
                    <h2 class="fs-3 text my-3 mx-3">Eventos</h2>
                    <table id="myTable" class="table table-striped" style="width:100%">
                        <thead>
                            <tr>
                                <th>Título</th>
                                <th>Fecha evento</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if ($eventos)
                            @foreach ($eventos as $evento)
                            <tr>
                                <td>{{ $evento->titulo }}</td>
                                <td>{{ \Carbon\Carbon::parse($evento->fecha_evento)->locale('es')->translatedFormat('d \d\e F \d\e Y') }}
                                <td>
                                    <div class="flex justify-center rounded-lg text-lg" role="group">
                                        <!-- botón editar -->
                                        @can('editar-evento')
                                        <a href="{{ route('panel-eventos.index', ['event_id' => $evento->id]) }}"
                                            class="">
                                            <button class="btn btn-secondary">
                                                Editar
                                            </button>
                                        </a>
                                        @endcan
                                        <!-- botón borrar -->
                                        @can('borrar-evento')
                                        <form action="{{ route('panel-eventos.destroy', $evento->id) }}"
                                            method="POST" class="formEliminar">
                                            @csrf
                                            @method('DELETE')
                                            <button style="color: black" type="submit"
                                                class="btn btn-danger">Borrar</button>
                                        </form>
                                        @endcan
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                            @endif
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>Título</th>
                                <th>Fecha evento</th>
                                <th>Acciones</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
<script>
    (function() {
        'use strict'
        //debemos crear la clase formEliminar dentro del form del boton borrar
        //recordar que cada registro a eliminar esta contenido en un form  
        var forms = document.querySelectorAll('.formEliminar')
        Array.prototype.slice.call(forms)
            .forEach(function(form) {
                form.addEventListener('submit', function(event) {
                    event.preventDefault()
                    event.stopPropagation()
                    Swal.fire({
                        title: '¿Confirma la eliminación del registro?',
                        icon: 'info',
                        showCancelButton: true,
                        confirmButtonColor: '#20c997',
                        cancelButtonColor: '#6c757d',
                        confirmButtonText: 'Confirmar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            this.submit();
                            Swal.fire('¡Eliminado!',
                                'El registro ha sido eliminado exitosamente.', 'success');
                        }
                    })
                }, false)
            })
    })()
</script>
<script>
    $(document).ready(function() {
        $('#myTable').DataTable({
            "pagingType": "simple_numbers",
            "order": [],
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ entradas",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "previous": "Anterior",
                    "next": "Siguiente"
                }
            }
        });
    });
</script>