<x-app-layout>
    @section('title', 'Blogs: Inicio')
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Blogs del Comité') }}
        </h2>
    </x-slot>

    <div class="container py-12 mx-auto">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="" style="background-color: white; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);">
                <div class="container ">
                    @can('crear-blog')
                    <a href="{{ route('panel-blogs.create') }}" class="">
                        <button class="btn btn-primary mt-3 mb-3 ml-3">
                            Subir nuevo
                        </button>
                    </a>
                    @endcan
                </div>
                <div class="container">
                    @if (session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"
                            aria-label="Close"></button>
                    </div>
                    @endif
                    <table id="myTable" class="table table-striped" style="width:100%">
                        <thead>
                            <tr>
                                <th>Título</th>
                                {{-- <th>Slug</th> --}}
                                <th>Extracto</th>
                                {{-- <th>Contenido</th> --}}
                                <th>Miniatura</th>
                                {{-- <th>Imagen 2</th> --}}
                                <th>Fecha Publicación</th>
                                <th>¿Publicado?</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if ($blogs)
                            @foreach ($blogs as $blog)
                            <tr>
                                <td>
                                    <a href="{{ route('blogs.mostrar', $blog->slug) }}" title="{{ $blog->titulo }}"
                                        rel="noopener" target="_blank">{{ $blog->titulo }}
                                    </a>
                                </td>
                                <td>{{ $blog->extracto }}</td>
                                <td>
                                    <a href="{{ asset($blog->imagen_1) }}" target="_blank">
                                        <img src="{{ asset($blog->imagen_1) }}" class="img-thumbnail"
                                            width="100%">
                                    </a>
                                </td>
                                <td>
                                    {{ \Carbon\Carbon::parse($blog->published_at)->locale('es')->translatedFormat('d \d\e F \d\e Y') }}
                                </td>
                                <td>{{ $blog->is_published ? 'Sí' : 'No' }}</td>
                                <td>
                                    <div class="flex justify-center rounded-lg text-lg" role="group">
                                        <!-- botón editar -->
                                        @can('editar-blog')
                                        <a href="{{ route('panel-blogs.edit', $blog->id) }}" class="">
                                            <button class="btn btn-secondary">
                                                Editar
                                            </button>
                                        </a>
                                        @endcan
                                        <!-- botón borrar -->
                                        @can('borrar-blog')
                                        <form action="{{ route('panel-blogs.destroy', $blog->id) }}"
                                            method="POST" class="formEliminar">
                                            @csrf
                                            @method('DELETE')
                                            <button style="color: black" type="submit"
                                                class="btn btn-danger">Borrar</button>
                                        </form>
                                        @endcan
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                            @endif
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>Título</th>
                                <th>Extracto</th>
                                <th>Miniatura</th>
                                <th>Fecha Publicación</th>
                                <th>¿Publicado?</th>
                                <th>Acciones</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
<script>
    (function() {
        'use strict'
        //debemos crear la clase formEliminar dentro del form del boton borrar
        //recordar que cada registro a eliminar esta contenido en un form  
        var forms = document.querySelectorAll('.formEliminar')
        Array.prototype.slice.call(forms)
            .forEach(function(form) {
                form.addEventListener('submit', function(event) {
                    event.preventDefault()
                    event.stopPropagation()
                    Swal.fire({
                        title: '¿Confirma la eliminación del registro?',
                        icon: 'info',
                        showCancelButton: true,
                        confirmButtonColor: '#20c997',
                        cancelButtonColor: '#6c757d',
                        confirmButtonText: 'Confirmar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            this.submit();
                            Swal.fire('¡Eliminado!',
                                'El registro ha sido eliminado exitosamente.', 'success');
                        }
                    })
                }, false)
            })
    })()
</script>
<script>
    $(document).ready(function() {
        $('#myTable').DataTable({
            "pagingType": "simple_numbers",
            "order": [],
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ entradas",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "previous": "Anterior",
                    "next": "Siguiente"
                }
            }
        });
    });
</script>