<x-app-layout>
    @section('title', 'Blogs: Editar')
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Editar Blog') }}
        </h2>
    </x-slot>

    <div class="container bg-white">
        <div class="form-container py-3">
            <div class="form-header py-3">
                <h2>Editar Blog</h2>
            </div>
            <form action="{{ route('panel-blogs.update', $blogs->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="container">
                    <div class="custom-section-title"><i class="fa-solid fa-file-signature"></i>
                        Título del blog: *
                    </div>
                    <input type="text" class="custom-input @error('titulo') is-invalid @enderror" id="titulo"
                        name="titulo" value="{{ old('titulo', $blogs->titulo) }}">
                    @error('titulo')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="container my-2">
                    <div class="custom-section-title"><i class="fa-solid fa-text-width"></i>
                        Extracto: *
                    </div>
                    <textarea class="custom-textarea @error('extracto') is-invalid @enderror" id="extracto" name="extracto" rows="4">{{ old('extracto', $blogs->extracto) }}</textarea>
                    @error('extracto')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="container my-2">
                    <div class="custom-section-title"><i class="fa-solid fa-pen-nib"></i>
                        Contenido
                    </div>
                    <textarea class="custom-textarea @error('contenido') is-invalid @enderror" id="contenido" name="contenido"
                        rows="8">{{ old('contenido', $blogs->contenido) }}</textarea>
                    @error('contenido')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="container my-2">
                    <div class="custom-section-title"><i class="fa-solid fa-calendar-days"></i>
                        Fecha de publicación: *
                    </div>
                    <input type="date" class="custom-input @error('published_at') is-invalid @enderror"
                        id="published_at" name="published_at" value="{{ old('published_at', $blogs->published_at) }}">
                    @error('published_at')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="container my-2">
                    <div class="custom-section-title"><i class="fa-solid fa-image"></i>
                        Miniatura: *
                    </div>
                    <input type="file" class="custom-input @error('imagen_1') is-invalid @enderror" id="imagen_1"
                        name="imagen_1">
                    @if ($blogs->imagen_1)
                        <div class="custom-center">
                            <p class="custom-label">Imagen actual:</p>
                            <img src="{{ asset($blogs->imagen_1) }}" alt="Imagen 1 actual"
                                class="custom-image-preview">
                        </div>
                    @endif
                </div>
                <div class="container">
                    <div class="custom-section-title"><i class="fa-solid fa-image"></i>
                        Adicionales: *
                    </div>
                    <div class="custom-col custom-note">
                        <p class="custom-note-text">
                            Si no se muestra una imagen en las secciones siguientes es
                            porque su blog no tiene adicionales, no se preocupe puede dejarlo vacío.
                        </p>
                    </div>
                </div>
                @if ($blogs->imagen_2 || $blogs->imagen_3 || $blogs->imagen_4 || $blogs->imagen_5)
                    @for ($i = 2; $i <= 5; $i++)
                        <div class="custom-row">
                            <div class="custom-col">
                                <label for="imagen_{{ $i }}" class="custom-label"></label>
                                <div class="custom-section-title"><i class="fa-solid fa-image"></i>
                                    Imagen
                                    {{ $i - 1 }} del blog:
                                </div>
                                <input type="file"
                                    class="custom-input @error('imagen_{{ $i }}') is-invalid @enderror"
                                    id="imagen_{{ $i }}" name="imagen_{{ $i }}"
                                    onchange="previewImage(this, 'preview_imagen_{{ $i }}')">
                                @if ($blogs->{'imagen_' . $i})
                                    <div class="custom-center">
                                        <p class="custom-label">Imagen actual:</p>
                                        <img src="{{ asset($blogs->{'imagen_' . $i}) }}"
                                            alt="Imagen {{ $i }} actual" class="custom-image-preview"
                                            id="preview_imagen_{{ $i }}">
                                        <button type="button" class="custom-button custom-button-danger"
                                            onclick="removeImage('{{ $i }}')">Eliminar</button>
                                        <input type="hidden" name="eliminar_imagen_{{ $i }}"
                                            id="eliminar_imagen_{{ $i }}" value="0">
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endfor
                @else
                    <div class="custom-row">
                        <div class="custom-col">
                            <label for="agregarImagenes" class="custom-label"><i class="fa-solid fa-images"></i>
                                ¿Deseas agregar imágenes adicionales?</label>
                            <select id="agregarImagenes" class="custom-input"
                                onchange="toggleImagenesExtras(this.value)">
                                <option selected disabled>Seleccione</option>
                                <option value="0">No</option>
                                <option value="1">Sí</option>
                            </select>
                        </div>
                    </div>
                    <div class="custom-row" id="cantidadImagenesExtras" style="display: none;">
                        <div class="custom-col">
                            <label for="cantidadImagenes" class="custom-label"><i class="fa-regular fa-images"></i>
                                ¿Cuántas imágenes adicionales?</label>
                            <select id="cantidadImagenes" class="custom-input"
                                onchange="mostrarInputsImagenes(this.value)">
                                <option value="0">Selecciona</option>
                                <option value="1">1</option>
                                <option value="2">2</option>
                                <option value="3">3</option>
                                <option value="4">4</option>
                            </select>
                        </div>
                    </div>
                    <div id="imagenesExtras" style="display: none;">
                        @for ($i = 2; $i <= 5; $i++)
                            <div class="custom-row" id="imagen_{{ $i }}" style="display: none;">
                                <div class="custom-col">
                                    <label for="imagen_{{ $i }}" class="custom-label"><i
                                            class="fa-solid fa-file-image"></i> Imagen Extra
                                        {{ $i - 1 }}</label>
                                    <input type="file" class="custom-input" name="imagen_{{ $i }}"
                                        onchange="previewImage(this, 'preview_imagen_{{ $i }}')">
                                    <img id="preview_imagen_{{ $i }}" class="custom-image-preview">
                                </div>
                            </div>
                        @endfor
                    </div>
                @endif
                <div class="custom-row">
                    <div class="custom-col">
                        <label for="is_published" class="custom-label">¿Publicado?</label>
                        <select class="custom-input" id="is_published" name="is_published">
                            <option value="1" {{ $blogs->is_published == 1 ? 'selected' : '' }}>Sí
                            </option>
                            <option value="0" {{ $blogs->is_published == 0 ? 'selected' : '' }}>No
                            </option>
                        </select>
                    </div>
                </div>
                <div class="d-flex justify-content-between">
                    <a href="{{ route('blogs.index') }}"
                        class="custom-button custom-button-secondary w-100">Cancelar</a>
                    <button type="submit" class="custom-button custom-button-success w-100">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</x-app-layout>
<script>
    document.getElementById('imagen_1').addEventListener('change', function(event) {
        const [file] = event.target.files;
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById('miniaturaSeleccionada').src = e.target.result;
            };
            reader.readAsDataURL(file);
        }
    });

    function previewImage(input, previewId) {
        const [file] = input.files;
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById(previewId).src = e.target.result;
            };
            reader.readAsDataURL(file);
        }
    }

    function toggleImagenesExtras(value) {
        document.getElementById('cantidadImagenesExtras').style.display = value == "1" ? 'block' : 'none';
        if (value == "0") {
            document.getElementById('imagenesExtras').style.display = 'none';
            document.getElementById('cantidadImagenes').value = '0';
            mostrarInputsImagenes('0');
        }
    }

    function mostrarInputsImagenes(value) {
        const total = parseInt(value);
        for (let i = 2; i <= 5; i++) {
            document.getElementById('imagen_' + i).style.display = i <= total + 1 ? 'block' : 'none';
            document.getElementById('preview_imagen_' + i).src = '';
        }
        document.getElementById('imagenesExtras').style.display = total > 0 ? 'block' : 'none';
    }

    function removeImage(index) {
        document.getElementById('imagen_' + index).value = '';
        document.getElementById('preview_imagen_' + index).src = '';
        document.getElementById('eliminar_imagen_' + index).value = '1';
    }
</script>
