<x-app-layout>
    @section('title', 'Blogs: Crear')
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Subir nuevo blog') }}
        </h2>
    </x-slot>

    <div class="container bg-white">
        <div class="form-container py-3">
            <div class="form-header py-3">
                <h2>Subir blog</h2>
            </div>
            <form action="{{ route('blogs.store') }}" method="POST" enctype="multipart/form-data" novalidate>
                @csrf
                <div class="mb-3">
                    <div class="container">
                        <div class="custom-section-title"><i class="fa-solid fa-file-signature"></i>
                            Título del blog: *
                        </div>
                        <input name="titulo" type="text" id="titulo" placeholder="Blog del Dia de..."
                            class="form-control @error('titulo') is-invalid @enderror" value="{{ old('titulo') }}"
                            @error('titulo') autofocus @enderror required>
                        @error('titulo')
                            <small class="invalid-feedback">
                                <strong>{{ $message }}</strong>
                            </small>
                        @enderror
                    </div>
                    <div class="container my-2">
                        <div class="custom-section-title"><i class="fa-solid fa-text-width"></i>
                            Extracto: *
                        </div>
                        <textarea class="form-control" placeholder="Una linea interesante del blog..." id="extracto" name="extracto"
                            rows="4" required value="{{ old('extracto') }}"></textarea>
                        @error('extracto')
                            <small class="invalid-feedback">
                                <strong>{{ $message }}</strong>
                            </small>
                        @enderror
                    </div>
                    <div class="container my-2">
                        <div class="custom-section-title"><i class="fa-solid fa-calendar-days"></i>
                            Fecha de publicación: *
                        </div>
                        <input name="published_at" type="date" id="published_at"
                            class="form-control @error('published_at') is-invalid @enderror"
                            value="{{ old('published_at') }}" required>
                        @error('published_at')
                            <small class="invalid-feedback">
                                <strong>{{ $message }}</strong>
                            </small>
                        @enderror
                    </div>
                    <div class="container my-2">
                        <div class="custom-section-title"><i class="fa-solid fa-pen-nib"></i>
                            Contenido: *
                        </div>
                        <textarea class="custom-textarea" placeholder="Coloca todo lo del blog aqui..." id="contenido" name="contenido"
                            rows="4" required></textarea>
                        @error('contenido')
                            <small class="invalid-feedback">
                                <strong>{{ $message }}</strong>
                            </small>
                        @enderror
                    </div>
                    <div class="container my-2">
                        <div class="custom-section-title"><i class="fa-solid fa-image"></i>
                            Miniatura: *
                        </div>
                        <input accept=".jpg,.png,.svg,.jpeg" name="imagen_1" id="imagen_1" type="file"
                            class="form-control @error('imagen_1') is-invalid @enderror"
                            @error('imagen_1') autofocus @enderror required>
                        @error('imagen_1')
                            <small class="invalid-feedback">
                                <strong>{{ $message }}</strong>
                            </small>
                        @enderror
                        <div class="row text-center">
                            <div class="custom-col">
                                <img id="miniaturaSeleccionada" class="custom-image-preview">
                            </div>
                        </div>
                    </div>
                    <div class="custom-row">
                        <div class="custom-col">
                            <label for="agregarImagenes" class="custom-label"><i class="fa-solid fa-images"></i>
                                ¿Deseas agregar imágenes adicionales?</label>
                            <select id="agregarImagenes" class="custom-input"
                                onchange="toggleImagenesExtras(this.value)">
                                <option selected disabled>Seleccione</option>
                                <option value="0">No</option>
                                <option value="1">Sí</option>
                            </select>
                        </div>
                    </div>
                    <div class="custom-row" id="cantidadImagenesExtras" style="display: none;">
                        <div class="custom-col">
                            <label for="cantidadImagenes" class="custom-label"><i class="fa-regular fa-images"></i>
                                ¿Cuántas imágenes adicionales?</label>
                            <select id="cantidadImagenes" class="custom-input"
                                onchange="mostrarInputsImagenes(this.value)">
                                <option value="0">Selecciona</option>
                                <option value="1">1</option>
                                <option value="2">2</option>
                                <option value="3">3</option>
                                <option value="4">4</option>
                            </select>
                        </div>
                    </div>
                    <div id="imagenesExtras" style="display: none;">
                        <div class="custom-row" id="imagen_2" style="display: none;">
                            <div class="custom-col">
                                <label for="imagen_2" class="custom-label"><i class="fa-solid fa-file-image"></i> Imagen
                                    Extra 1</label>
                                <input type="file" class="custom-input" name="imagen_2"
                                    onchange="previewImage(this, 'preview_imagen_2')">
                                <img id="preview_imagen_2" class="custom-image-preview">
                            </div>
                        </div>
                        <div class="custom-row" id="imagen_3" style="display: none;">
                            <div class="custom-col">
                                <label for="imagen_3" class="custom-label"><i class="fa-solid fa-file-image"></i>
                                    Imagen Extra 2</label>
                                <input type="file" class="custom-input" name="imagen_3"
                                    onchange="previewImage(this, 'preview_imagen_3')">
                                <img id="preview_imagen_3" class="custom-image-preview">
                            </div>
                        </div>
                        <div class="custom-row" id="imagen_4" style="display: none;">
                            <div class="custom-col">
                                <label for="imagen_4" class="custom-label"><i class="fa-solid fa-file-image"></i>
                                    Imagen Extra 3</label>
                                <input type="file" class="custom-input" name="imagen_4"
                                    onchange="previewImage(this, 'preview_imagen_4')">
                                <img id="preview_imagen_4" class="custom-image-preview">
                            </div>
                        </div>
                        <div class="custom-row" id="imagen_5" style="display: none;">
                            <div class="custom-col">
                                <label for="imagen_5" class="custom-label"><i class="fa-solid fa-file-image"></i>
                                    Imagen Extra 4</label>
                                <input type="file" class="custom-input" name="imagen_5"
                                    onchange="previewImage(this, 'preview_imagen_5')">
                                <img id="preview_imagen_5" class="custom-image-preview">
                            </div>
                        </div>
                    </div>
                    <div class="custom-row">
                        <div class="custom-col">
                            <label for="is_published" class="custom-label">¿Publicado?</label>
                            <select class="custom-input" id="is_published" name="is_published">
                                <option selected disabled>Seleccione</option>
                                <option value="0">No</option>
                                <option value="1">Sí</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="d-flex justify-content-between">
                    <a href="{{ route('blogs.index') }}"
                        class="custom-button custom-button-secondary w-100">Cancelar</a>
                    <button type="submit" class="custom-button custom-button-success w-100">Subir</button>
                </div>
            </form>
        </div>
    </div>

</x-app-layout>
<script>
    document.getElementById('imagen_1').addEventListener('change', function(event) {
        const [file] = event.target.files;
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById('miniaturaSeleccionada').src = e.target.result;
            };
            reader.readAsDataURL(file);
        }
    });

    function previewImage(input, previewId) {
        const [file] = input.files;
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById(previewId).src = e.target.result;
            };
            reader.readAsDataURL(file);
        }
    }

    function toggleImagenesExtras(value) {
        document.getElementById('cantidadImagenesExtras').style.display = value == "1" ? 'block' : 'none';
        if (value == "0") {
            document.getElementById('imagenesExtras').style.display = 'none';
            document.getElementById('cantidadImagenes').value = '0';
            mostrarInputsImagenes('0');
        }
    }

    function mostrarInputsImagenes(value) {
        const total = parseInt(value);
        for (let i = 2; i <= 5; i++) {
            document.getElementById('imagen_' + i).style.display = i <= total + 1 ? 'block' : 'none';
            document.getElementById('preview_imagen_' + i).src = '';
        }
        document.getElementById('imagenesExtras').style.display = total > 0 ? 'block' : 'none';
    }
</script>
