                    <div class="fotos-navegacion" id="fotos-navegacion">
                        @php
                            use Illuminate\Pagination\LengthAwarePaginator;
                            // Obtener todas las fechas de las fotos
                            $fechasFotos = App\Models\Fotografia::orderBy('fecha', 'desc')->pluck('fecha');

                            // Agrupar las fechas por mes y año
                            $fechasAgrupadas = $fechasFotos->groupBy(function ($date) {
                                return Carbon\Carbon::parse($date)->format('F Y');
                            });

                            // Paginar las fechas agrupadas manualmente
                            $currentPage = request()->query('page', 1);
                            $itemsPerPage = 1; // Una página por mes
                            $currentItems = $fechasAgrupadas
                                ->slice(($currentPage - 1) * $itemsPerPage, $itemsPerPage)
                                ->all();
                            $fechasPaginadas = new LengthAwarePaginator(
                                $currentItems,
                                count($fechasAgrupadas),
                                $itemsPerPage,
                                $currentPage,
                                ['path' => url()->current()],
                            );
                        @endphp

                        @if ($fechasPaginadas->isEmpty())
                            <p>No hay fotos disponibles.</p>
                        @else
                            @foreach ($fechasPaginadas as $mesAnio => $fotosPorMesAnio)
                                @php
                                    $mesAnioTraducido = Carbon\Carbon::parse($mesAnio)
                                        ->locale('es')
                                        ->isoFormat('MMMM [de] YYYY');

                                    $fotosDelMes = App\Models\Fotografia::whereYear(
                                        'fecha',
                                        Carbon\Carbon::parse($mesAnio)->year,
                                    )
                                        ->whereMonth('fecha', Carbon\Carbon::parse($mesAnio)->month)
                                        ->get();
                                    $eventos = $fotosDelMes->groupBy('nombre_evento');
                                @endphp

                                <div class="mes">
                                    <h2 class="text-capitalize">{{ $mesAnioTraducido }}</h2>

                                    @foreach ($eventos as $nombreEvento => $fotosPorEvento)
                                        <h3 class="text-capitalize text-black">{{ $nombreEvento }}</h3>
                                        <div class="row photos" id="{{ Str::slug($mesAnio) }}">
                                            @foreach ($fotosPorEvento as $foto)
                                                <div class="col-sm-6 col-md-4 col-lg-3 item">
                                                    <div class="fotografia-item">
                                                        <div class="blog-img">
                                                            <a href="imagenes/fotos-carpeta/{{ $foto->nombre_archivo }}"
                                                                data-lightbox="photos" title="{{ $nombreEvento }}"
                                                                rel="noopener">
                                                                <img class="img-fluid"
                                                                    src="imagenes/fotos-carpeta/{{ $foto->nombre_archivo }}"
                                                                    loading="lazy" alt="{{ $nombreEvento }}"
                                                                    title="{{ $nombreEvento }}">
                                                            </a>

                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    @endforeach
                                </div>
                            @endforeach
                        @endif
                        <div class="container" style="display:flex; justify-content:center">
                            {{ $fechasPaginadas->links('pagination::bootstrap-4') }}
                        </div>
                    </div>