@extends('componentes.plantilla')
@section('title', 'Inicio')
@section('meta-description',
    'Bienvenido a la página de inicio del Comité de Igualdad Laboral y No Discriminación de la
    Secretaría de Planeación, Finanzas y Administración del Gobierno del Estado de Puebla.')
@section('canonical-url', url()->current())
@section('keywords',
    'Inicio, Comité Igualdad Laboral, No Discriminación, Secretaría de Planeación, Finanzas y Administración, Gobierno
    del Estado de Puebla, Igualdad de Género, No Discriminación Laboral, Puebla, Progreso, Transparencia, Información')
@section('og-title', 'Inicio - Comité de Igualdad Laboral y No Discriminación')
@section('og-description',
    'Bienvenido a la página de inicio del Comité de Igualdad Laboral y No Discriminación de la
    Secretaría de Planeación, Finanzas y Administración del Gobierno del Estado de Puebla.')
@section('og:url', url()->current())
@section('twitter-title', 'Inicio - Comité de Igualdad Laboral y No Discriminación')
@section('twitter-description',
    'Bienvenido a la página de inicio del Comité de Igualdad Laboral y No Discriminación de
    la Secretaría de Planeación, Finanzas y Administración del Gobierno del Estado de Puebla.')
@section('css')
    {!! NoCaptcha::renderJs() !!}
@endsection
@section('jss')
@endsection
@section('content')
    @if ($message = Session::get('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ $message }}'
            })
        </script>
    @endif
    <section class="seccion-inicial">
        <div class="container">
            <div class="row">
                <div class="col-12 col-md-6 titulo">
                    <h1 class="titulo-h1">
                        Comité de Igualdad Laboral y No
                        Discriminación
                    </h1>
                    <p class="text-justify">
                        Promover e incorporar la igualdad laboral y no
                        discriminación como valor institucional al interior de la
                        Secretaría de Planeación, Finanzas y Administración
                    </p>
                    <a href="contacto" class="btn btn-orange" title="Contáctanos" rel="noopener" target="_self">
                        Contáctanos</a>
                </div>
                <div class="col-12 col-md-6 imagen">
                    <div id="carouselExampleControls" class="carousel slide" data-ride="carousel">
                        <div class="carousel-inner">
                            <div class="carousel-item active">
                                <div class="img-box">
                                    <img src="{{ asset('imagenes/carrusel-inicio/1.jpg') }}" alt="imagen de carrusel 1"
                                        title="imagen de carrusel 1">
                                </div>
                            </div>
                            <div class="carousel-item">
                                <div class="img-box">
                                    <img src="{{ asset('imagenes/carrusel-inicio/2.jpg') }}" alt="imagen de carrusel 2"
                                        title="imagen de carrusel 2">
                                </div>
                            </div>
                            <div class="carousel-item">
                                <div class="img-box">
                                    <img src="{{ asset('imagenes/carrusel-inicio/3.jpg') }}" alt="imagen de carrusel 3"
                                        title="imagen de carrusel 3">
                                </div>
                            </div>
                            <div class="carousel-item">
                                <div class="img-box">
                                    <img src="{{ asset('imagenes/carrusel-inicio/4.jpg') }}" alt="imagen de carrusel 4"
                                        title="imagen de carrusel 4">
                                </div>
                            </div>
                            <div class="carousel-item">
                                <div class="img-box">
                                    <img src="{{ asset('imagenes/carrusel-inicio/5.jpg') }}" alt="imagen de carrusel 5"
                                        title="imagen de carrusel 5">
                                </div>
                            </div>
                        </div>
                    </div>
                    <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleControls"
                        data-bs-slide="prev">
                        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">Anterior</span>
                    </button>
                    <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleControls"
                        data-bs-slide="next">
                        <span class="carousel-control-next-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">Siguiente</span>
                    </button>
                </div>
            </div>
        </div>

    </section>
    {{-- <section class="slider_section layout_padding">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <div class="detail_box">
                        <h1 class="titulo-h1">
                            Comité de Igualdad Laboral y No <br>
                            Discriminación
                        </h1>
                        <p class="text-justify">
                            Promover e incorporar la igualdad laboral y no
                            discriminación como valor institucional al interior de la
                            Secretaría de Planeación, Finanzas y Administración
                        </p>
                        <a href="contacto" class="btn btn-orange" title="Contáctanos" rel="noopener" target="_self">
                            Contáctanos</a>
                    </div>
                </div>

                <div class="col-lg-5 col-md-6 offset-lg-1">
                    <div class="img_content">
                        <div class="img_container">
                            <div id="carouselExampleControls" class="carousel slide" data-ride="carousel">
                                <div class="carousel-inner">
                                    <div class="carousel-item active">
                                        <div class="img-box">
                                            <img src="{{ asset('imagenes/carrusel-inicio/1.jpg') }}"
                                                alt="imagen de carrusel 1" title="imagen de carrusel 1">
                                        </div>
                                    </div>
                                    <div class="carousel-item">
                                        <div class="img-box">
                                            <img src="{{ asset('imagenes/carrusel-inicio/2.jpg') }}"
                                                alt="imagen de carrusel 2" title="imagen de carrusel 2">
                                        </div>
                                    </div>
                                    <div class="carousel-item">
                                        <div class="img-box">
                                            <img src="{{ asset('imagenes/carrusel-inicio/3.jpg') }}"
                                                alt="imagen de carrusel 3" title="imagen de carrusel 3">
                                        </div>
                                    </div>
                                    <div class="carousel-item">
                                        <div class="img-box">
                                            <img src="{{ asset('imagenes/carrusel-inicio/4.jpg') }}"
                                                alt="imagen de carrusel 4" title="imagen de carrusel 4">
                                        </div>
                                    </div>
                                    <div class="carousel-item">
                                        <div class="img-box">
                                            <img src="{{ asset('imagenes/carrusel-inicio/5.jpg') }}"
                                                alt="imagen de carrusel 5" title="imagen de carrusel 5">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleControls"
                            data-bs-slide="prev">
                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Anterior</span>
                        </button>
                        <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleControls"
                            data-bs-slide="next">
                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Siguiente</span>
                        </button>

                    </div>
                </div>
            </div>
        </div>
    </section> --}}
    <section id="about_section" class="about_section layout_padding">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <div class="detail-box">
                        <div class="heading_container">
                            <h2 class="titulo-h2">Sobre nosotros</h2>
                        </div>
                        <p class="text-justify">
                            Somos un equipo de trabajo conformado por personas de diversas
                            unidades administrativas de la Secretaría de Planeación, Finanzas y Administración, cuyo fin es
                            promover e incorporar la Igualdad
                            Laboral y No Discriminación como valor institucional al
                            interior de la Secretaría, nuestro objetivo es alcanzar un
                            equilibrio integral en el ejercicio de los derechos del
                            personal que forma parte de esta Dependencia, a través de la
                            igualdad de oportunidades.
                        </p>
                        <a href="{{ url('/acercade') }}" title="Acerca del Comité" rel="noopener" target="_self">
                            Leer
                            más
                        </a>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="img_container">
                        <div class="img-box b1">
                            <img src="{{ asset('imagenes/carrusel-inicio/8.jpg') }}" alt="Imagen de Acerca de Nosotros"
                                title="Imagen de Acerca de Nosotros">
                        </div>
                        <div class="img-box b2">
                            <img src="{{ asset('imagenes/carrusel-inicio/7.jpg') }}" alt="Imagen 2 de Acerca de Nosotros"
                                title="Imagen 2 de Acerca de Nosotros">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    {{-- <section id="infografias" class="carousel_section layout_padding">
        <div class="container">
            <div class="heading_container text-center">
                <h2 class="titulo-h2">Infografías</h2>
            </div>
            <div class="container-fluid">
                <div class="row justify-content-center">
                    <div class="col-md-12">
                        <div id="infographicsCarousel" class="carousel slide" data-ride="carousel">
                            <!-- Indicadores -->
                            <div class="carousel-indicators">
                                @foreach ($infografias as $index => $infografia)
                                    <button type="button" data-bs-target="#infographicsCarousel"
                                        data-bs-slide-to="{{ $index }}" class="{{ $index == 0 ? 'active' : '' }}"
                                        aria-label="Slide {{ $index + 1 }}"
                                        {{ $index == 0 ? 'aria-current="true"' : '' }}></button>
                                @endforeach
                            </div>
                            <div class="carousel-inner">
                                @foreach ($infografias as $index => $infografia)
                                    <div class="carousel-item {{ $index == 0 ? 'active' : '' }}">
                                        <div class="box text-center">
                                            <div class="img-box">
                                                <img src="{{ asset('imagenes/infografias-carpeta/' . $infografia->infografia) }}"
                                                    alt="{{ $infografia->nombre }}" class="img-fluid"
                                                    title="{{ $infografia->nombre }}">
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <button class="carousel-control-prev" type="button" data-bs-target="#infographicsCarousel"
                                data-bs-slide="prev">
                                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                <span class="visually-hidden">Anterior</span>
                            </button>
                            <button class="carousel-control-next" type="button" data-bs-target="#infographicsCarousel"
                                data-bs-slide="next">
                                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                <span class="visually-hidden">Siguiente</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="text-center">
                <a href="galeria-infografias" class="btn btn-orange mt-3" title="Galería de Infografías" rel="noopener"
                    target="_self">Ver más</a>
            </div>
        </div>
    </section> --}}
    <section id="infografias" class="secccion_infografias">
        <div class="container">
            <div class="heading_container text-center">
                <h2 class="titulo-h2">Infografías</h2>
            </div>
            <div class="container-fluid">
                <div class="row justify-content-center">
                    <div class="col-md-12">
                        <div id="infographicsCarousel" class="carousel slide" data-ride="carousel">
                            <div class="carousel-indicators">
                                @foreach ($infografias as $index => $infografia)
                                    <button type="button" data-bs-target="#infographicsCarousel"
                                        data-bs-slide-to="{{ $index }}" class="{{ $index == 0 ? 'active' : '' }}"
                                        aria-label="Slide {{ $index + 1 }}"
                                        {{ $index == 0 ? 'aria-current="true"' : '' }}></button>
                                @endforeach
                            </div>
                            <div class="carousel-inner">
                                @foreach ($infografias as $index => $infografia)
                                    <div class="carousel-item {{ $index == 0 ? 'active' : '' }}">
                                        <div class="box text-center">
                                            <div class="img-box">
                                                <img src="{{ asset('imagenes/infografias-carpeta/' . $infografia->infografia) }}"
                                                    alt="{{ $infografia->nombre }}" class="img-fluid"
                                                    title="{{ $infografia->nombre }}">
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <button class="carousel-control-prev" type="button" data-bs-target="#infographicsCarousel"
                                data-bs-slide="prev">
                                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                <span class="visually-hidden">Anterior</span>
                            </button>
                            <button class="carousel-control-next" type="button" data-bs-target="#infographicsCarousel"
                                data-bs-slide="next">
                                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                <span class="visually-hidden">Siguiente</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="text-center">
                <a href="galeria-infografias" class="btn btn-orange mt-3" title="Galería de Infografías" rel="noopener"
                    target="_self">Ver más</a>
            </div>
        </div>
    </section>

    <section id="blogs" class="about_section layout_padding">
        <div class="container">
            <div class="heading_container text-center">
                <h2 class="titulo-h2">Blogs</h2>
            </div>
            <div class="row">
                @if ($blogs->count() > 0)
                    @foreach ($blogs as $blog)
                        <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12 col-12">
                            <div class="blog-card">
                                <div class="blog-card-img">
                                    <a href="{{ route('blogs.mostrar', $blog->slug) }}" title="{{ $blog->titulo }}"
                                        rel="noopener" target="_self">
                                        <img src="{{ asset($blog->imagen_1) }}"
                                            alt="Imagen del blog {{ $blog->titulo }}"
                                            title="Imagen del blog {{ $blog->titulo }}">
                                    </a>
                                </div>
                                <div class="blog-card-text-area">
                                    <div class="blog-date">
                                        <ul>
                                            <li>
                                                <i class="fas fa-user"></i>
                                                Por
                                                <a href="{{ url('/integrantes') }}" target="_self" rel="noopener"
                                                    title="Integrantes">
                                                    Admin
                                                </a>
                                            </li>
                                            <li>
                                                <i class="far fa-calendar-alt"></i>
                                                {{ \Carbon\Carbon::parse($blog->published_at)->locale('es')->isoFormat('DD MMM YYYY') }}
                                            </li>
                                        </ul>
                                    </div>
                                    <h4 class="titulo-blog-tarjeta">
                                        <a href="{{ route('blogs.mostrar', $blog->slug) }}" title="{{ $blog->titulo }}"
                                            rel="noopener" target="_self">
                                            {{ $blog->titulo }}
                                        </a>
                                    </h4>
                                    <p class="extracto-tarjeta">
                                        {{ $blog->extracto }}
                                    </p>
                                </div>
                                <div class="container d-flex justify-content-center">
                                    <a class="read-more-btn" href="{{ route('blogs.mostrar', $blog->slug) }}"
                                        title="{{ $blog->titulo }}" rel="noopener" target="_self">
                                        Leer Más
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @else
                    <h4 class="text-center">No hay blogs disponibles.</h4>
                @endif

                <div class="text-center">
                    <a href="eventos#blogs" class="btn btn-orange mt-3" title="Galería de Infografías" rel="noopener"
                        target="_self">Ver más</a>
                </div>
            </div>
        </div>
    </section>
    <section class="contact_section layout_padding">
        <div class="container">
            <div class="heading_container">
                <h2 class="titulo-h2">Contáctanos</h2>
            </div>
        </div>
        <div class="container">
            <div class="row">
                <div style="margin-top:20px">
                    @if (session('success'))
                        <div class="alert alert-success text-center">
                            {{ session('success') }}
                        </div>
                    @endif
                </div>
                <div class="col-md-6">
                    <div class="">
                        <form action="{{ route('panel-quejas.store') }}" method="post" enctype="multipart/form-data"
                            novalidate>
                            @csrf
                            <div class="form-group">
                                <label for="nombre">Nombre completo:</label>
                                <input type="text" id="nombre" name="nombre" class="form-control" required>
                                @error('nombre')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="correo">Correo electrónico:</label>
                                <input type="email" id="correo" name="correo" class="form-control" required>
                                @error('correo')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="telefono">Número de teléfono:</label>
                                <input type="tel" id="telefono" name="telefono" class="form-control" required>
                                @error('telefono')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="tipo_discriminacion">Tipo de Queja:</label>
                                <select id="tipo_discriminacion" name="tipo_discriminacion" class="form-control"
                                    required>
                                    <option value="" disabled selected>Seleccione</option>
                                    <option value="Acoso y Hostigamiento Sexual">Acoso y Hostigamiento Sexual</option>
                                    <option value="Acoso y Hostigamiento Laboral">Acoso y Hostigamiento Laboral
                                    </option>
                                    <option value="Discriminación">Discriminación</option>
                                </select>
                                @error('tipo_discriminacion')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="queja">Describa su queja:</label>
                                <textarea id="queja" name="queja" class="form-control" rows="4" required></textarea>
                                @error('queja')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div id="descarga-formato" class="form-group" style="display:none;">
                                <p>Descarga el siguiente formato, llénalo y adjúntalo al siguiente apartado.</p>
                                <a id="descargar-formato" class="btn btn-orange" href="#" download
                                    title="Formato de Queja" rel="noopener">Descargar
                                    formato</a>
                            </div>

                            <div class="form-group">
                                <label for="formato">Adjuntar documento (solo PDF o Word):</label>
                                <input type="file" id="formato" name="formato" class="form-control"
                                    accept=".pdf,.docx" required>
                                @error('formato')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-12">
                                {!! NoCaptcha::display() !!}
                                @error('g-recaptcha-response')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label>Documentos complementarios</label>
                            </div>
                            <div class="form-group">
                                <p>Descarga el siguiente directorio, para que encuentres la instancia más cercana a ti y
                                    puedas continuar con el procedimiento de tu incidente.</p>
                                <a class="btn btn-orange" href="{{ asset('documentos/Directorio-Protocolo.pdf') }}"
                                    download title="Directorio" rel="noopener">Descargar directorio</a>
                            </div>

                            <!-- Modal de Bootstrap -->
                            <div class="modal fade" id="avisoPrivacidadModal" tabindex="-1"
                                aria-labelledby="avisoPrivacidadModalLabel" aria-hidden="true">
                                <div class="modal-dialog modal-xl">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="avisoPrivacidadModalLabel">Aviso de Privacidad
                                            </h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Cerrar"></button>
                                        </div>
                                        <div class="modal-body">
                                            <iframe class="w-100" id="avisoPrivacidadIframe" src=""></iframe>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Modificación en el Formulario -->
                            <div class="form-group">
                                <label>Aviso de privacidad</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <button type="button" class="btn btn-orange-2 btn-aviso-privacidad mt-0 w-100"
                                            data-tipo="simplificado">Simplificado</button>
                                    </div>
                                    <div class="col-md-6">
                                        <button type="button" class="btn btn-orange-2 btn-aviso-privacidad mt-0 w-100"
                                            data-tipo="integral">Integral</button>
                                    </div>
                                </div>
                            </div>

                            <!-- Botones de documentos extras -->
                            <div class="form-group">
                                <label>Anexos</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <a class="btn btn-orange-2 w-100"
                                            href="{{ asset('documentos/6._Anexo_IX.4._Minuta_de_Resolución.docx') }}"
                                            download rel="noopener" title="Minuta de Resolución">Minuta de
                                            Resolución</a>
                                    </div>
                                    <div class="col-md-6">
                                        <a class="btn btn-orange-2 w-100"
                                            href="{{ asset('documentos/5._Anexo_IX.3._Minuta_de_Entrevista_Protocolo_y_Acuerdo.docx') }}"
                                            download title="Minuta de Entrevista Protocolo y Acuerdo"
                                            rel="noopener">Minuta de Entrevista Protocolo y Acuerdo</a>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <input type="submit" value="Enviar" class="btn btn-orange">
                            </div>
                        </form>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="map_container">
                        <div class="map-responsive">
                            <iframe id="iframe-mapa-contacto"
                                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d629.3230731027531!2d-98.18690585600862!3d19.03395814966306!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x85cfc7113bf027f9%3A0x5019db208e053e0!2sSecretaria%20de%20Finanzas%20de%20Gobierno%20del%20Puebla!5e0!3m2!1sen!2smx!4v1695752002387!5m2!1sen!2smx"
                                width="600" height="640" allowfullscreen title="Ifram de Google Maps"
                                loading="lazy"></iframe>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

{{-- <script async src="https://www.googletagmanager.com/gtag/js?id=G-XY18X19KGL"></script>
<script>
    window.dataLayer = window.dataLayer || [];

    function gtag() {
        dataLayer.push(arguments);
    }
    gtag("js", new Date());

    gtag("config", "G-XY18X19KGL");
</script>
<script type="text/javascript" src="bni_1896b1697d8ca9f980069c2600d67e25.js"></script>
<script language="JavaScript" type="text/javascript">
    var _0x5aae = [
        "cookie",
        "x-bni-fpc=",
        "; expires=Thu, 01 Jan 2037 00:00:00 UTC; path=/;",
        "x-bni-rncf=1696261434768; expires=Thu, 01 Jan 2037 00:00:00 UTC; path=/;",
        "get",
    ];

    function fiprn() {
        new fiprn_v2()[_0x5aae[4]](function(_0x6130x2, _0x6130x3) {
            (document[_0x5aae[0]] = _0x5aae[1] + _0x6130x2 + _0x5aae[2]),
            (document[_0x5aae[0]] = _0x5aae[3]);
        });
    }
</script>
<script>
    fiprn();
</script> --}}
@section('scripts')
    <script>
        document.getElementById('tipo_discriminacion').addEventListener('change', function() {
            var descargaFormatoDiv = document.getElementById('descarga-formato');
            var descargarFormatoLink = document.getElementById('descargar-formato');

            if (this.value === 'Acoso y Hostigamiento Sexual') {
                descargaFormatoDiv.style.display = 'block';
                descargarFormatoLink.href =
                    '{{ asset('documentos/Formato de Queja Acoso, Hostigamiento Sexual.docx') }}';
            } else if (this.value === 'Acoso y Hostigamiento Laboral') {
                descargaFormatoDiv.style.display = 'block';
                descargarFormatoLink.href =
                    '{{ asset('documentos/Formato de Queja Acoso, Hostigamiento Laboral y Discriminación.docx') }}';
            } else if (this.value === 'Discriminación') {
                descargaFormatoDiv.style.display = 'block';
                descargarFormatoLink.href =
                    '{{ asset('documentos/Formato de Queja Acoso, Hostigamiento Laboral y Discriminación.docx') }}';
            } else {
                descargaFormatoDiv.style.display = 'none';
            }
        });

        document.querySelectorAll('.btn-aviso-privacidad').forEach(button => {
            button.addEventListener('click', function() {
                var tipo = this.getAttribute('data-tipo');
                var iframe = document.getElementById('avisoPrivacidadIframe');
                if (tipo === 'simplificado') {
                    iframe.src = '{{ asset('documentos/AvisoPrivacidadSimplificado.pdf') }}';
                } else if (tipo === 'integral') {
                    iframe.src = '{{ asset('documentos/AvisoPrivacidadIntegral.pdf') }}';
                }
                var modal = new bootstrap.Modal(document.getElementById('avisoPrivacidadModal'));
                modal.show();
            });
        });
    </script>
    <!-- <script>
        document.addEventListener("DOMContentLoaded", function() {
            var bannerModal = new bootstrap.Modal(document.getElementById('bannerModal'));
            bannerModal.show();
        });
    </script> -->
@endsection
