@extends('componentes.plantilla')
@section('title', 'Infografías del comité')
@section('meta-description',
    'Descubre las infografías del Comité de Igualdad Laboral y No Discriminación de la
    Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla, que comunican de manera visual nuestros valores y
    compromisos.')
@section('canonical-url', url()->current())
@section('keywords',
    'Infografías, Comité Igualdad Laboral, No Discriminación, Secretaría de Planeación y Finanzas,
    Gobierno del Estado de Puebla, Igualdad de Género, No Discriminación Laboral, Puebla, Sustentabilidad, Visualización de
    Datos')
@section('og-title', 'Infografías - Comité de Igualdad Laboral y No Discriminación')
@section('og-description',
    'Descubre las infografías del Comité de Igualdad Laboral y No Discriminación de la Secretaría
    de Planeación y Finanzas del Gobierno del Estado de Puebla, que comunican de manera visual nuestros valores y
    compromisos.')
@section('og:url', url()->current())
@section('twitter-title', 'Infografías - Comité de Igualdad Laboral y No Discriminación')
@section('twitter-description',
    'Descubre las infografías del Comité de Igualdad Laboral y No Discriminación de la
    Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla, que comunican de manera visual nuestros valores y
    compromisos.')

@section('css')
    <link rel="stylesheet" href="{{ asset('css/lightbox.css') }}">
    <script src="{{ asset('js/lightbox.js') }}"></script>
@endsection
@section('jss-inicial')
@endsection
@section('content')
    <section>
        <div class="lightbox-gallery">
            <div class="container">
                <div class="intro">
                    <h1 class="text-center my-3 titulo-h1">Galeria de Infografías</h1>
                    <p class="text-justify">Descubre nuestras infografías informativas: representaciones visuales que
                        simplifican
                        temas complejos y facilitan la comprensión de información importante.</p>
                </div>
                <div class="row photos">
                    @if ($infografias->count() > 0)
                        @foreach ($infografias as $infografia)
                            <div class="col-sm-6 col-md-4 col-lg-3 item">
                                <div class="infografia-item">
                                    <div class="blog-img">
                                        <a href="/imagenes/infografias-carpeta/{{ $infografia->infografia }}"
                                            data-lightbox="photos" title="{{ $infografia->nombre }}" rel="noopener">
                                            <img class="img-fluid"
                                                src="/imagenes/infografias-carpeta/miniaturas/{{ $infografia->miniatura }}"
                                                loading="lazy" title="{{ $infografia->nombre }}"
                                                alt="{{ $infografia->nombre }}">
                                        </a>
                                    </div>
                                </div>

                            </div>
                        @endforeach
                    @else
                        <p>No hay infografías disponibles.</p>
                    @endif
                    <div class="container text-center">
                        {{-- {{ $infografias->links('pagination::bootstrap-4') }} --}}
                        {{ $infografias->onEachSide(1)->links('pagination::bootstrap-4') }}
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('scripts')
@endpush
