@extends('componentes.plantilla')
@section('title', 'Galeria fotográfica del comité')
@section('meta-description',
    'Explora la galería fotográfica de los eventos del Comité de Igualdad Laboral y No
    Discriminación de la Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla, donde celebramos nuestros
    logros y promovemos la inclusión y la igualdad.')
@section('canonical-url', url()->current())
@section('keywords',
    'Galería Fotográfica, Eventos, Comité Igualdad Laboral, No Discriminación, Secretaría de Planeación
    y Finanzas, Gobierno del Estado de Puebla, Igualdad de Género, No Discriminación Laboral, Puebla, Inclusión,
    Celebraciones')
@section('og-title', 'Galería Fotográfica - Eventos del Comité de Igualdad Laboral y No Discriminación')
@section('og-description',
    'Explora la galería fotográfica de los eventos del Comité de Igualdad Laboral y No
    Discriminación de la Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla, donde celebramos nuestros
    logros y promovemos la inclusión y la igualdad.')
@section('og:url', url()->current())
@section('twitter-title', 'Galería Fotográfica - Eventos del Comité de Igualdad Laboral y No Discriminación')
@section('twitter-description',
    'Explora la galería fotográfica de los eventos del Comité de Igualdad Laboral y No
    Discriminación de la Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla, donde celebramos nuestros
    logros y promovemos la inclusión y la igualdad.')

@section('css')
    <link rel="stylesheet" href="{{ asset('css/lightbox.css') }}">
    <script src="{{ asset('js/lightbox.js') }}"></script>
@endsection 
@section('jss-inicial')
@endsection
@section('content')
    <section>
        <div class="lightbox-gallery">
            <div class="container">
                <div class="intro">
                    <h1 class="text-center my-3 titulo-h1">Galeria de fotografías</h1>
                    <p class="text-justify">
                        Explora nuestra galería de fotografías del Comité de Igualdad Laboral
                        y No Discriminación para descubrir momentos inspiradores y acciones
                        que promueven la igualdad y la diversidad en el entorno laboral.
                    </p>

                    <div class="form-group-fotos">
                        <label for="month-select" class="form-label">Elija el mes:</label>
                        <select id="month-select" class="form-select">
                            <option value="">Seleccione un mes</option>
                            @foreach ($months as $monthNumber => $monthName)
                                <option value="{{ $monthNumber }}">{{ $monthName }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="fotos-navegacion" id="fotos-navegacion">
                    @if ($fechasPaginadas->isEmpty())
                        <p>No hay fotos disponibles.</p>
                    @else
                        @foreach ($fechasPaginadas as $mesAnio => $fotosPorMesAnio)
                            @php
                                $mesAnioTraducido = Carbon\Carbon::parse($mesAnio)
                                    ->locale('es')
                                    ->isoFormat('MMMM [de] YYYY');

                                $fotosDelMes = App\Models\Fotografia::whereYear(
                                    'fecha',
                                    Carbon\Carbon::parse($mesAnio)->year,
                                )
                                    ->whereMonth('fecha', Carbon\Carbon::parse($mesAnio)->month)
                                    ->orderBy('nombre_evento')
                                    ->orderBy('nombre_archivo')
                                    ->get();

                                $eventos = $fotosDelMes->groupBy('nombre_evento');
                            @endphp

                            <div class="mes">
                                <h2 class="text-capitalize">{{ $mesAnioTraducido }}</h2>

                                @foreach ($eventos as $nombreEvento => $fotosPorEvento)
                                    <h3 class="text-capitalize text-black">{{ $nombreEvento }}</h3>
                                    <div class="row photos" id="{{ Str::slug($mesAnio) }}">
                                        @foreach ($fotosPorEvento as $foto)
                                            @php
                                                $extension = pathinfo($foto->nombre_archivo, PATHINFO_EXTENSION);
                                                $extensionesImagen = ['jpeg', 'jpg', 'png', 'svg'];
                                                $extensionesVideo = ['mp4', 'mov', 'avi', 'wmv'];
                                            @endphp
                                            @if (in_array($extension, $extensionesImagen))
                                                <div class="col-sm-6 col-md-4 col-lg-3 item">
                                                    <div class="fotografia-item">
                                                        <div class="blog-img">
                                                            <a href="imagenes/fotos-carpeta/{{ $foto->nombre_archivo }}"
                                                                data-lightbox="photos" title="{{ $nombreEvento }}"
                                                                rel="noopener">
                                                                <img class="img-fluid"
                                                                    src="imagenes/fotos-carpeta/{{ $foto->nombre_archivo }}"
                                                                    loading="lazy" alt="{{ $nombreEvento }}"
                                                                    title="{{ $nombreEvento }}">
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            @elseif(in_array($extension, $extensionesVideo))
                                                <div class="col-sm-6 col-md-4 col-lg-3">
                                                    <video controls class="video-comite-fotos" >
                                                        <source src="imagenes/fotos-carpeta/{{ $foto->nombre_archivo }}"
                                                            type="video/{{ $extension }}">
                                                        Tu navegador no soporta la reproducción de videos.
                                                    </video>
                                                </div>
                                            @endif
                                        @endforeach
                                    </div>
                                @endforeach
                            </div>
                        @endforeach
                    @endif
                    <div class="container" style="display:flex; justify-content:center">
                        {{ $fechasPaginadas->links('pagination::bootstrap-4') }}
                    </div>
                </div>

                <div class="fotos-mes" id="fotos-mes" style="display: none; position: relative;">
                    {{-- Aqui se llena con las fotos agrupadas filtradas por el select de arriba --}}
                </div>
            </div>
        </div>
    </section>
@endsection

@section('scripts')
    <script>
        document.getElementById('month-select').addEventListener('change', function() {
            // Obtén el valor del select
            let monthYear = this.value;

            // Verifica que el valor no esté vacío
            if (monthYear) {
                fetch(`/mostrar_fotos_por_mes/${monthYear}`)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error('La solicitud ha fallado');
                        }
                        return response.text();
                    })
                    .then(data => {
                        // Muestra el contenedor de fotos y oculta el contenedor de navegación
                        document.getElementById('fotos-navegacion').style.display = 'none';
                        document.getElementById('fotos-mes').innerHTML = data;
                        document.getElementById('fotos-mes').style.display = 'block';
                    })
                    .catch(error => {
                        console.error('Error:', error);
                    });
            } else {
                // Si el valor es vacío o nulo, oculta el contenedor de fotos por mes y muestra el de navegación
                document.getElementById('fotos-mes').style.display = 'none';
                document.getElementById('fotos-navegacion').style.display = 'block';
            }
        });
    </script>

@endsection
