<div id="fotos-mes" style="display: block;">
    @if ($groupedData_fotos->isEmpty())
        <p>No hay fotos disponibles para el mes seleccionado.</p>
    @else
        <div class="fotos-grid">
            <h2 class="text-capitalize">{{ $monthName }} de {{ $year }}</h2>
            @foreach ($groupedData_fotos as $nombreEvento => $fotosPorEvento)
                <h3 class="text-black">{{ $nombreEvento }}</h3>
                <div class="row photos" id="{{ Str::slug($nombreEvento) }}">
                    @foreach ($fotosPorEvento as $foto)
                        @php
                            $extension = pathinfo($foto->nombre_archivo, PATHINFO_EXTENSION);
                            $extensionesImagen = ['jpeg', 'jpg', 'png', 'svg'];
                            $extensionesVideo = ['mp4', 'mov', 'avi', 'wmv'];
                        @endphp

                        @if (in_array($extension, $extensionesImagen))
                            <div class="col-sm-6 col-md-4 col-lg-3 item">
                                <div class="fotografia-item">
                                    <div class="blog-img">
                                        <a href="{{ asset('imagenes/fotos-carpeta/' . $foto->nombre_archivo) }}"
                                            data-lightbox="photos" title="{{ $nombreEvento }}" rel="noopener">
                                            <img class="img-fluid"
                                                src="{{ asset('imagenes/fotos-carpeta/' . $foto->nombre_archivo) }}"
                                                loading="lazy" alt="{{ $nombreEvento }}" title="{{ $nombreEvento }}">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        @elseif(in_array($extension, $extensionesVideo))
                            <div class="col-sm-12 col-md-12 col-lg-12">
                                <video controls class="video-comite-fotos">
                                    <source src="{{ asset('imagenes/fotos-carpeta/' . $foto->nombre_archivo) }}"
                                        type="video/{{ $extension }}">
                                    Tu navegador no soporta la reproducción de videos.
                                </video>
                            </div>
                        @endif
                    @endforeach
                </div>
            @endforeach
        </div>
    @endif
</div>
