@extends('componentes.plantilla')
@section('title', 'Eventos del comité')
@section('meta-description',
    'Descubre los eventos y blogs del Comité de Igualdad Laboral y No Discriminación de la
    Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla, donde mantenemos informados a nuestros
    colaboradores y público en general sobre nuestras actividades y reflexiones.')
@section('canonical-url', url()->current())
@section('keywords',
    'Eventos, Blogs, Comité Igualdad Laboral, No Discriminación, Secretaría de Planeación y Finanzas,
    Gobierno del Estado de Puebla, Igualdad de Género, No Discriminación Laboral, Puebla, Calendario de Eventos,
    Publicaciones, Reflexiones')
@section('og-title', 'Eventos y Blogs - Comité de Igualdad Laboral y No Discriminación')
@section('og-description',
    'Descubre los eventos y blogs del Comité de Igualdad Laboral y No Discriminación de la
    Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla, donde mantenemos informados a nuestros
    colaboradores y público en general sobre nuestras actividades y reflexiones.')
@section('og:url', url()->current())
@section('twitter-title', 'Eventos y Blogs - Comité de Igualdad Laboral y No Discriminación')
@section('twitter-description',
    'Descubre los eventos y blogs del Comité de Igualdad Laboral y No Discriminación de la
    Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla, donde mantenemos informados a nuestros
    colaboradores y público en general sobre nuestras actividades y reflexiones.')

@section('css')
@endsection
@section('content')
    <section id="eventos" class="text-center">
        <div class="container py-4">
            <h1 class="titulo-h1">Eventos</h1>
        </div>
        <div class="container">
            <div class="row">
                <div class="carousel slide" data-ride="carousel" id="event-carousel" data-interval="false">
                    <div class="carousel-inner">
                        @if ($eventos->count() > 0)
                            @foreach ($eventos as $mes => $eventosDelMes)
                                <div class="carousel-item {{ $mes == $mesActual ? 'active' : '' }}">
                                    <div class="event-container">
                                        <div class="event-header">
                                            <div class="event-month-year">
                                                {{ ucfirst(Carbon\Carbon::parse($mes . '-01')->isoFormat('MMMM YYYY')) }}
                                            </div>
                                        </div>
                                        @foreach ($eventosDelMes as $evento)
                                            <div class="container event-item">
                                                <div class="row">
                                                    <div class="col-md-2 event-date">
                                                        <div class="day">
                                                            {{ \Carbon\Carbon::parse($evento->fecha_evento)->day }}
                                                        </div>
                                                        <span
                                                            class="weekday">{{ \Carbon\Carbon::parse($evento->fecha_evento)->locale('es')->isoFormat('dddd') }}</span>
                                                    </div>
                                                    <div class="col-md-10 event-desc">
                                                        <div class="title">{{ $evento->titulo }}</div>
                                                        <div class="subtitle">
                                                            {{ $evento->subtitulo }}
                                                        </div>
                                                        <p>{{ $evento->descripcion }}</p>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endforeach
                        @else
                            <p>No hay eventos disponibles.</p>
                        @endif
                    </div>
                    <!-- Carousel Slide Container -->
                    <a class="carousel-control-prev eventos-carousel-control" href="#event-carousel" role="button"
                        data-bs-slide="prev">
                        <span class="carousel-control-prev-icon eventos-icon" aria-hidden="true"></span>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next eventos-carousel-control" href="#event-carousel" role="button"
                        data-bs-slide="next">
                        <span class="carousel-control-next-icon eventos-icon" aria-hidden="true"></span>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
        </div>
        <!-- Container -->
    </section>
    <section class="blog-details" id="blogs">
        <div class="container pt-5">
            <div class="container">
                <div class="row">
                    <h1 class="titulo-h1">Blogs</h1>
                </div>
            </div>
            <div class="row">
                @if ($blogs->count() > 0)
                    @foreach ($blogs as $blog)
                        <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
                            <div class="blog-card">
                                <div class="blog-card-img">
                                    <a href="{{ route('blogs.mostrar', $blog->slug) }}" title="{{ $blog->titulo }}"
                                        rel="noopener" target="_self"><img src="{{ asset($blog->imagen_1) }}"
                                            alt="Imagen del blog {{ $blog->titulo }}"
                                            title="Imagen del blog {{ $blog->titulo }}">
                                    </a>
                                </div>
                                <div class="blog-card-text-area">
                                    <div class="blog-date">
                                        <ul>
                                            <li>
                                                <i class="fas fa-user"></i>
                                                Por
                                                <a href="{{ url('/integrantes') }}" target="_self" rel="noopener"
                                                    title="Integrantes">
                                                    Admin
                                                </a>
                                            </li>
                                            <li>
                                                <i class="far fa-calendar-alt"></i>
                                                {{ \Carbon\Carbon::parse($blog->published_at)->locale('es')->isoFormat('DD MMM YYYY') }}
                                            </li>
                                        </ul>
                                    </div>
                                    <h4 class="titulo-blog-tarjeta">
                                        <a href="{{ route('blogs.mostrar', $blog->slug) }}" title="{{ $blog->titulo }}"
                                            rel="noopener" target="_self">
                                            {{ $blog->titulo }}
                                        </a>
                                    </h4>
                                    <p class="extracto-tarjeta">
                                        {{ $blog->extracto }}
                                    </p>
                                </div>
                                <div class="container d-flex justify-content-center">
                                    <a class="read-more-btn" href="{{ route('blogs.mostrar', $blog->slug) }}"
                                        title="{{ $blog->titulo }}" rel="noopener" target="_self">
                                        Leer Más
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                    <div class="container text-center mt-2">
                        {{-- {{ $infografias->links('pagination::bootstrap-4') }} --}}
                        {{ $blogs->onEachSide(1)->links('pagination::bootstrap-4') }}
                    </div>
                @else
                    <h4 class="text-center">No hay blogs disponibles.</h4>
                @endif

            </div>
        </div>
    </section>
@endsection

@push('scripts')
@endpush
