@extends('componentes.plantilla')
@section('title', 'Documentación del comité')
@section('meta-description',
    'Explora la documentación del Comité de Igualdad Laboral y No Discriminación de la
    Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla, que incluye normativas, actas e informes
    relacionados con nuestros valores fundamentales.')
@section('canonical-url', url()->current())
@section('keywords',
    'Documentación, Normas, Actas, Informes, Comité Igualdad Laboral, No Discriminación, Secretaría de
    Planeación y Finanzas, Gobierno del Estado de Puebla, Igualdad de Género, No Discriminación Laboral, Puebla,
    Sustentabilidad, Transparencia, Información')
@section('og-title', 'Documentación - Comité de Igualdad Laboral y No Discriminación')
@section('og-description',
    'Explora la documentación del Comité de Igualdad Laboral y No Discriminación de la Secretaría
    de Planeación y Finanzas del Gobierno del Estado de Puebla, que incluye normativas, actas e informes relacionados con
    nuestros valores fundamentales.')
@section('og:url', url()->current())
@section('twitter-title', 'Documentación - Comité de Igualdad Laboral y No Discriminación')
@section('twitter-description',
    'Explora la documentación del Comité de Igualdad Laboral y No Discriminación de la
    Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla, que incluye normativas, actas e informes
    relacionados con nuestros valores fundamentales.')

@section('jss')
    <script>
        function openModal(url, title) {
            // Actualizar el título del modal y la URL del iframe
            document.getElementById("pdfModalLabel").innerHTML = title;
            document.getElementById("pdfFrame").src = url;

            // Mostrar el modal de Bootstrap
            var pdfModal = new bootstrap.Modal(document.getElementById('pdfModal'), {
                keyboard: true
            });
            pdfModal.show();
        }
    </script>
@endsection
@section('css')
@endsection
@section('content')
    <section class="layout_padding"
        style="background-image: url('{{ asset('imagenes/fondo4.png') }}'); background-size: cover; background-repeat: no-repeat;">
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-justify">
                    <div class="detail-box">
                        <div class="heading_container">
                            <h2 class="titulo-h2">
                                Documentación
                            </h2>
                        </div>
                        <p class="text-justify">
                            La
                            <strong>Norma Mexicana NMX-R-025-SCFI-2015 en Igualdad Laboral y No
                                Discriminación</strong>
                            ofrece un mecanismo voluntario para reconocer a los centros de
                            trabajo que promueven la igualdad laboral y la no discriminación,
                            contribuyendo al desarrollo integral de sus empleados. Esta
                            certificación está dirigida a una amplia gama de centros de
                            trabajo en México, sin importar su tamaño, sector o actividad.
                            Para obtenerla, los centros de trabajo deben someterse a una
                            auditoría de tercera parte, garantizando que sus políticas y
                            prácticas cumplan con los requisitos de igualdad laboral y no
                            discriminación.
                        </p>
                        <h3 class="text-justify">
                            Principales ejes de la norma:
                        </h3>
                        <ul class="text-justify">
                            <li>
                                Incorporación de la perspectiva de género y no discriminación en
                                procesos de reclutamiento, selección, movilidad y capacitación.
                            </li>
                            <li>
                                Garantía de la igualdad salarial.
                            </li>
                            <li>
                                Implementación de medidas para prevenir y abordar la violencia
                                laboral.
                            </li>
                            <li>
                                Fomento de la corresponsabilidad entre la vida laboral, familiar
                                y personal de los trabajadores, con igualdad de trato y
                                oportunidades.
                            </li>
                        </ul>
                        <p>
                            Esta norma reconoce que alcanzar la igualdad sustantiva implica
                            una transformación cultural en las organizaciones, por lo que uno
                            de sus principios fundamentales es la progresividad, aplicándose
                            de manera gradual.
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="container">
            <div class="modal fade" id="pdfModal" tabindex="-1" aria-labelledby="pdfModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-xl">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="pdfModalLabel">Documento</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <iframe id="pdfFrame" src=""></iframe>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <div class="detail-box">
                        <div class="heading_container">
                            <h2>Documentos 2025</h2>
                        </div>
                        <ul class="document-tree lista-sin-punto">
                            <li class="folder">
                                <input type="checkbox" id="folder1" />
                                <label for="folder1">Documentos técnicos</label>
                                <ul class="sub-documents lista-sin-punto">
                                      <li>
                                        <a href="#pdf1"
                                            onclick="openModal('{{ asset('documentos/tecnicos/ACUERDO_QUE_ESTABLECE_EL_CILYND.pdf') }}', 'Lineamientos de Operación del Comité')">
                                            — Acuerdo por el que se establece el Comité de Igualdad Laboral y No Discriminación 
                                            de la Secretaría de Planeación, Finanzas y Administración</a>
                                    </li>
                                    <li>
                                        <a href="#pdf1"
                                            onclick="openModal('{{ asset('documentos/tecnicos/lineamientos CILND.pdf') }}', 'Lineamientos de Operación del Comité')">
                                            — Lineamientos de Operación del Comité de Igualdad Laboral y No
                                            Discriminación</a>
                                    </li>
                                    <li>
                                        <a href="#pdf2"
                                            onclick="openModal('{{ asset('documentos/normativos/politica23.pdf') }}', 'Política de Igualdad Laboral y No Discriminación')">—
                                            Política de Igualdad Laboral y No Discriminación</a>
                                    </li>
                                    <li>
                                        <a href="#pdf3"
                                            onclick="openModal('{{ asset('documentos/normativos/Protocolo-Hostigamiento-Acoso-Sexual.pdf') }}', 'Protocolo para la Atención de Quejas por Acoso y Hostigamiento Sexual')">—
                                            Protocolo
                                            para la Atención de Quejas por Acoso y Hostigamiento <strong>Sexual</strong>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="#pdf4"
                                            onclick="openModal('{{ asset('documentos/normativos/Protocolo-Hostigamiento-Acoso-Laboral.pdf') }}', 'Protocolo para la Atención al Acompañamiento de Quejas por Acoso y Hostigamiento Laboral y Discriminación')">—
                                            Protocolo
                                            para la Atención al Acompañamiento de Quejas por Acoso y Hostigamiento
                                            <strong>Laboral</strong> y <strong>Discriminación</strong></a>
                                    </li>
                                    <li>
                                        <a href="#pdf5"
                                            onclick="openModal('{{ asset('documentos/tecnicos/guialenguaje.pdf') }}', 'Recomendaciones para El Uso del Lenguaje Incluyente y Libre de Discriminación')">—
                                            Recomendaciones para El Uso del Lenguaje Incluyente y Libre
                                            de Discriminación</a>
                                    </li>
                                    <li>
                                        <a href="#pdf6"
                                            onclick="openModal('{{ asset('documentos/tecnicos/guialenguaje2.pdf') }}', 'Guía de Lenguaje Incluyente para la Administración Pública del Estado de Puebla')">—
                                            Guía
                                            de Lenguaje Incluyente para la Administración Pública
                                            del Estado de Puebla</a>
                                    </li>
                                    <li>
                                        <a href="#pdf7"
                                            onclick="openModal('{{ asset('documentos/tecnicos/PRONUNCIAMIENTO.pdf') }}', 'Pronunciamiento de Cero Tolerancia a las conductas de hostigamiento y/o acoso sexual en la Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla')">—
                                            Pronunciamiento de Cero Tolerancia a las conductas de hostigamiento y/o
                                            acoso sexual en la Secretaría de Planeación y Finanzas del Gobierno del
                                            Estado de Puebla</a>
                                    </li>
                                    <li>
                                        <a href="#pdf8"
                                            onclick="openModal('{{ asset('documentos/tecnicos/Certificado.pdf') }}', 'Certificado de Registro')">—
                                            Certificado de Registro</a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="detail-box">
                        <div class="heading_container">
                            <h2>Normas 2025</h2>
                        </div>
                        <ul class="document-tree lista-sin-punto">
                            <li class="folder">
                                <input type="checkbox" id="folder2" />
                                <label for="folder2">Normatividad</label>
                                <ul class="sub-documents lista-sin-punto">
                                    <li>
                                        <a href="#pdf9"
                                            onclick="openModal('{{ asset('documentos/normativos/CodigoEtica.pdf') }}', 'Código de Ética, y las Reglas de Integridad para el Ejercicio de la Función Pública')">—
                                            Código de Ética, y las Reglas de Integridad para el Ejercicio
                                            de la Función Pública.</a>
                                    </li>

                                    <li>
                                        <a href="#pdf10"
                                            onclick="openModal('{{ asset('documentos/normativos/NMX-R-025-SCFI-2015_2015_DGN.pdf') }}', 'Norma Mexicana NMX-R-025-SCFI-2015')">—
                                            Norma Mexicana NMX-R-025-SCFI-2015</a>
                                    </li>
                                    <li>
                                        <a href="#pdf11"
                                            onclick="openModal('{{ asset('documentos/normativos/codigodeconducta.pdf') }}', 'Código de Conducta de las y los servidores públicos de la Secretaría de Planeación y Finanzas')">—
                                            Código de Conducta de las y los servidores públicos de la
                                            Secretaría de Planeación y Finanzas</a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="detail-box">
                        <div class="heading_container">
                            <h2>Actas</h2>
                        </div>
                        <ul class="document-tree lista-sin-punto">
                            <li class="folder">
                                <input type="checkbox" id="folder3" />
                                <label for="folder3">2023</label>
                                <ul class="sub-documents lista-sin-punto">
                                    <label for="sub-documents">Ordinarias</label>
                                    <li>
                                        <a href="#pdf12"
                                            onclick="openModal('{{ asset('documentos/actas/acta_1a_sesion_ordi.pdf') }}', 'Primera sesión 2023')">—
                                            Primera sesión</a>
                                    </li>
                                    <li>
                                        <a href="#pdf13"
                                            onclick="openModal('{{ asset('documentos/actas/025-05-2023 Segunda Sesion Ordinaria CILND.pdf') }}', 'Segunda sesión 2023')">—
                                            Segunda sesión</a>
                                    </li>
                                    <li>
                                        <a href="#pdf14"
                                            onclick="openModal('{{ asset('documentos/actas/tercera_sesion_ord.pdf') }}', 'Tercera sesión 2023')">—
                                            Tercera sesión</a>
                                    </li>
                                </ul>
                                <ul class="sub-documents lista-sin-punto">
                                    <label for="sub-documents">Extraordiarias</label>
                                    <li>
                                        <a href="#pdf15"
                                            onclick="openModal('{{ asset('documentos/actas/002-05-2023 Primera Extra 2023 CILND.pdf') }}', 'Primera sesión Extraordinaria 2023')">—
                                            Primera sesión</a>
                                    </li>
                                    <li>
                                        <a href="#pdf16"
                                            onclick="openModal('{{ asset('documentos/actas/segunda_sesion_extraordinaria.pdf') }}', 'Segunda sesión Extraordinaria 2023')">—
                                            Segunda sesión</a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                        <ul class="document-tree lista-sin-punto">
                            <li class="folder">
                                <input type="checkbox" id="folder4" />
                                <label for="folder4">2024</label>
                                <ul class="sub-documents lista-sin-punto">
                                    <label for="sub-documents">Ordinarias</label>
                                    <li>
                                        <a href="#pdf17"
                                            onclick="openModal('{{ asset('documentos/actas/Primera Sesión ORdinaria 2024 CILND.pdf') }}', 'Primera sesión 2024')">—
                                            Primera sesión</a>
                                    </li>
                                    <li>
                                        <a href="#pdf18"
                                            onclick="openModal('{{ asset('documentos/actas/Acta Segunda Sesión Ordinaria 2024.pdf') }}', 'Segunda sesión 2024')">—
                                            Segunda sesión</a>
                                    </li>
                                    <li>
                                        <a href="#pdf14"
                                            onclick="openModal('{{ asset('documentos/actas/Acta-Tercera-Sesion-Ordinaria-2024.pdf') }}', 'Tercera sesión 2024')">—
                                            Tercera sesión</a>
                                    </li>
                                </ul>
                                <ul class="sub-documents">
                                    <label for="sub-documents">Extraordiarias</label>
                                    <li>
                                        <a href="#pdf19"
                                            onclick="openModal('{{ asset('documentos/actas/Primera Sesión Extraordinaria 2024 CILND.pdf') }}', 'Primera sesión Extraordinaria 2024')">—
                                            Primera sesión</a>
                                    </li>
                                    <li>
                                        <a href="#pdf20"
                                            onclick="openModal('{{ asset('documentos/actas/Acta de Segunda Sesion Extraordinaria CILND.pdf') }}', 'Segunda sesión Extraordinaria 2024')">—
                                            Segunda sesión</a>
                                    </li>
                                    <li>
                                        <a href="#pdf21"
                                            onclick="openModal('{{ asset('documentos/actas/tercera sesion extra cilnd.pdf') }}', 'Tercera sesión Extraordinaria 2024')">—
                                            Tercera sesión</a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="detail-box">
                        <div class="heading_container">
                            <h2>Planes e Informes</h2>
                        </div>
                        <ul class="document-tree lista-sin-punto">
                            <li class="folder">
                                <input type="checkbox" id="folder5" />
                                <label for="folder5">2023</label>
                                <ul class="sub-documents lista-sin-punto">
                                    <li>
                                        <a href="#pdf22"
                                            onclick="openModal('{{ asset('documentos/tecnicos/Resultados de la Encuesta de Clima Laboral.pdf') }}', 'Resultados de la Encuesta de Clima Laboral')">—
                                            Resultados de la Encuesta de Clima Laboral</a>
                                    </li>
                                    <li>
                                        <a href="#pdf23"
                                            onclick="openModal('{{ asset('documentos/tecnicos/InformedeActividades2023.pdf') }}', 'Informe de Actividades 2023')">—
                                            Informe
                                            de Actividades 2023</a>
                                    </li>
                                    <li>
                                        <a href="#pdf24"
                                            onclick="openModal('{{ asset('documentos/tecnicos/Reporte Plan de acción vida laboral y familiar 2023.pdf') }}', 'Reporte Plan de acción vida laboral y familiar 2023')">—
                                            Reporte Plan de acción vida laboral y familiar 2023</a>
                                    </li>
                                    <li>
                                        <a href="#pdf25"
                                            onclick="openModal('{{ asset('documentos/normativos/Planes_de_accion2023.pdf') }}', 'Plan de Acción')">—
                                            Plan de
                                            Acción</a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                        <ul class="document-tree lista-sin-punto">
                            <li class="folder">
                                <input type="checkbox" id="folder6" />
                                <label for="folder6">2024</label>
                                <ul class="sub-documents lista-sin-punto">
                                    <li>
                                        <a href="#pdf26"
                                            onclick="openModal('{{ asset('documentos/tecnicos/Plan de acción vida laboral y familiar 2024.pdf') }}', 'Plan de acción vida laboral y familiar 2024')">—
                                            Plan de acción vida laboral y familiar 2024</a>
                                    </li>
                                    <li>
                                        <a href="#pdf27"
                                            onclick="openModal('{{ asset('documentos/normativos/Plan Anual de Trabajo 2024.pdf') }}', 'Plan Anual de Trabajo 2024')">—
                                            Plan Anual de Trabajo 2024</a>
                                    </li>
                                    <li>
                                        <a href="#pdf28"
                                            onclick="openModal('{{ asset('documentos/tecnicos/Resultados_de_la_Encuesta_Clima_Laboral_2024.pdf') }}', 'Resultados de la Encuesta de Clima Laboral 2024')">—
                                            Resultados de la Encuesta de Clima Laboral</a>
                                    </li>
                                    <li>
                                        <a href="#pdf29"
                                            onclick="openModal('{{ asset('documentos/tecnicos/Informe-de-Actividades-2024.pdf') }}', 'Informe de Actividades 2024')">—
                                            Informe
                                            de Actividades 2024</a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <div class="container">
    </div>
@endsection

@push('scripts')
@endpush
