<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title') | Comité de Igualdad Laboral y No Discriminación</title>
    {{-- <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'> --}}
    <meta content='width=device-width, initial-scale=1, maximum-scale=1' name='viewport'>
    <meta name="description" content="@yield('meta-description', 'Página oficial del Comité de Igualdad Laboral y No Discriminación de la Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla. Promoviendo igualdad de oportunidades y derechos laborales.')">
    <meta name="keywords" content="@yield('keywords', 'Comité de Igualdad Laboral, No Discriminación, Secretaría de Planeación y Finanzas, Gobierno del Estado de Puebla, igualdad de oportunidades, derechos laborales, inclusión laboral, políticas de igualdad, equidad de género, diversidad laboral')">
    <meta name="author" content="Ing. Nery Pozos">
    <meta name="robots" content="index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1">
    <meta name="google" content="notranslate">
    <meta name="googlebot" content="index, follow">
    <meta name="google-site-verification" content="G-XY18X19KGL">
    <meta name="bingbot" content="index, follow">
    <meta name="referrer" content="no-referrer-when-downgrade">
    <meta name="format-detection" content="telephone=no">
    <meta name="HandheldFriendly" content="True">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="theme-color" content="#ab6157">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta property="og:title" content="@yield('og-title', 'Comité de Igualdad Laboral y No Discriminación - Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla')">
    <meta property="og:description" content="@yield('og-description', 'Página informativa del Comité de Igualdad Laboral y No Discriminación de la Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla')">
    <meta property="og:type" content="website">
    <meta property="og:url" content="@yield('og:url', 'https://comiteigualdadlaboralspf.puebla.gob.mx')">
    <meta property="og:image" content="@yield('og:image', 'https://comiteigualdadlaboralspf.puebla.gob.mx/imagenes/carrusel-inicio/1.jpg')">
    <meta property="og:site_name" content="@yield('og:site_name', 'Comité de Igualdad Laboral y No Discriminación de la Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla')">
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="@yield('twitter-title', 'Comité de Igualdad Laboral y No Discriminación de la Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla')">
    <meta name="twitter:description" content="@yield('twitter-description', 'Página Informativa del Comité de Igualdad Laboral y No Discriminación de la Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla')">
    <meta name="twitter:image" content="@yield('twitter:image', 'https://comiteigualdadlaboralspf.puebla.gob.mx/imagenes/carrusel-inicio/1.jpg')">
    <link rel="canonical" href="@yield('canonical-url', 'https://comiteigualdadlaboralspf.puebla.gob.mx')">

    <!-- Favicon -->
    <link href="{{ asset('imagenes/favicon.png') }}" rel="icon">

    @yield('page_css')
    <script src="{{ asset('js/sienna.min.js') }}" defer></script>

    <!-- Librerías de hojas de estilo de Owl Carousel -->
    <link rel="stylesheet" href="{{ asset('css/owl.carousel.css') }}">
    <link rel="stylesheet" href="{{ asset('css/owl.theme.default.min.css') }}">

    <!-- Librerias de AOS -->
    <link href="{{ asset('css/aos.css') }}" rel="stylesheet">

    <!-- Hojas de estilos de Bootstrap  -->
    <link rel="stylesheet" href="{{ asset('css/bootstrap.min.css') }}">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="{{ asset('fontAwesome/css/all.min.css') }}">
    {{-- <script src="https://kit.fontawesome.com/30136daf60.js" crossorigin="anonymous" defer></script> --}}

    <!-- CSS de la Página-->
    <link rel="stylesheet" href="{{ asset('css/estilos.css') }}?v={{ rand() }}">

    {{-- <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script> --}}
    <script src="{{ asset('js/sweetalert2@11.js') }}"></script>

    @yield('page_css')
    @yield('jss-inicial')
    @yield('jss')
    <script src="{{ asset('js/jquery.min.js') }}"></script>
    @yield('css')
</head>

<body>
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-KH1F0SWYQB"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());

        gtag('config', 'G-KH1F0SWYQB');
    </script>
    {{-- <div class="popup-container" id="popup">
        <div class="popup-content">
            <h4>Aviso</h4>
            <p>
                En apego a las acciones preventivas implementadas por la
                Administración Pública Estatal, con motivo del Proceso Electoral 2024,
                este contenido será modificado temporalmente en atención a las
                disposiciones legales y normativas en material electoral.
            </p>
            <button class="enterado-btn" onclick="closePopup()">Enterado</button>
        </div>
    </div> --}}
    <div id="thetop" class="thetop"></div>
    <div class='backtotop'>
        <a href="#thetop" class='scroll'>
            <i class="fas fa-angle-double-up"></i>
        </a>
    </div>

    <div class="loader-section">
        <span class="loader"></span>
    </div>
    <!-- Modal de Bootstrap -->
    <div class="modal fade" id="pdfModalUnique" tabindex="-1" aria-labelledby="pdfModalUniqueLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="pdfModalUniqueLabel">Certificado</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <iframe loading="lazy" style="width:100%; height:80vh; border:none;"
                        src="/documentos/tecnicos/Certificado.pdf"></iframe>
                </div>
            </div>
        </div>
    </div>
    <!-- Botón flotante -->
    <div class="floating-button">
        <button id="openPdfModalBtn" class="btn btn-floating" data-bs-toggle="modal"
            data-bs-target="#pdfModalUnique">
            <img src="{{ asset('imagenes/medalla.png') }}" alt="Medalla de Oro">
        </button>
    </div>
    <div class="wrapper">
        @auth
            <nav class="navbar navbar-expand-md navbar-light bg-white shadow-sm">
                <div class="container">
                    <a class="navbar-brand" href="{{ url('/') }}">
                        {{ config('Comité de Igualdad Laboral y No Discriminación', 'Comité de Igualdad Laboral y No Discriminación') }}
                    </a>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                        data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                        aria-expanded="false" aria-label="{{ __('Toggle navigation') }}">
                        <span class="navbar-toggler-icon"></span>
                    </button>

                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <!-- Left Side Of Navbar -->
                        <ul class="navbar-nav mr-auto">
                        </ul>
                        <!-- Right Side Of Navbar -->
                        <ul class="navbar-nav ml-auto">
                            <!-- Authentication Links -->
                            @guest
                                @if (Route::has('login'))
                                    <li class="nav-item">
                                        <a class="nav-link" href="{{ route('login') }}">{{ __('Login') }}</a>
                                    </li>
                                @endif

                                @if (Route::has('register'))
                                    <li class="nav-item">
                                        <a class="nav-link" href="{{ route('register') }}">{{ __('Register') }}</a>
                                    </li>
                                @endif
                            @else
                                <li class="nav-item dropdown">
                                    <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button"
                                        data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                                        {{ Auth::user()->name }}
                                    </a>

                                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                                        <a class="dropdown-item" href="{{ route('dashboard') }}">
                                            {{ __('Panel') }}
                                        </a>
                                        <a class="dropdown-item" href="{{ route('logout') }}"
                                            onclick="event.preventDefault();
                                                                    document.getElementById('logout-form').submit();">
                                            {{ __('Logout') }}
                                        </a>

                                        <form id="logout-form" action="{{ route('logout') }}" method="POST"
                                            class="d-none">
                                            @csrf
                                        </form>
                                    </div>
                                </li>
                            @endguest
                        </ul>
                    </div>
                </div>
            </nav>
        @endauth

        <main class="">
            @include('componentes.headers')
            <div id="customSearchModal" class="custom-modal-search">
                <div class="custom-modal-content">
                    <div class="custom-modal-header">
                        <span class="custom-close" onclick="closeSearchModal()">&times;</span>
                        <h5 class="custom-modal-title">Buscar con Google</h5>
                    </div>
                    <div class="custom-modal-body">
                        <script async src="https://cse.google.com/cse.js?cx=f2ac527e5e9834332"></script>
                        <div class="gcse-searchbox-only"></div>
                    </div>
                </div>
            </div>
            @yield('content')
            @include('componentes.carrusel-relacionados')
            @include('componentes.footer')
        </main>
    </div>

    @yield('scripts')
    <script src="{{ asset('js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('js/aos.js') }}"></script>
    <script src="{{ asset('js/owl.carousel.min.js') }}"></script>
    <script>
        function pageLoaded() {
            let loaderSection = document.querySelector(".loader-section");
            loaderSection.classList.add("loaded");
        }
        document.onload = pageLoaded();
    </script>
    <script>
        const navbar = document.getElementById("navbar");
        const navbarMovil = document.getElementById("movil-navbar");
        let lastScrollTop = 0;

        window.addEventListener("scroll", () => {
            const currentScroll = window.pageYOffset;

            if (currentScroll > 50) {
                // Aplica la clase sticky cuando se desplaza hacia abajo o arriba
                navbar.classList.add("sticky");
            } else {
                // Remueve la clase sticky cuando vuelve a la parte superior
                navbar.classList.remove("sticky");
            }

            lastScrollTop = currentScroll;
        });

        document.addEventListener("DOMContentLoaded", function() {
            const menuButton = document.getElementById("menuButton");
            const menuOverlay = document.getElementById("menuOverlay");
            const mobileMenu = document.getElementById("mobileMenu");

            menuButton.addEventListener("click", function() {
                mobileMenu.classList.add("active");
                menuOverlay.classList.add("active");
            });

            menuOverlay.addEventListener("click", function() {
                mobileMenu.classList.remove("active");
                menuOverlay.classList.remove("active");
            });
        });
    </script>
    <script>
        window.addEventListener("load", function() {
            let modal = document.getElementById("customSearchModal");

            window.openSearchModal = function() {
                modal.classList.add("show");
            };

            window.closeSearchModal = function() {
                modal.classList.remove("show");
            };

            window.onclick = function(event) {
                if (event.target === modal) {
                    closeSearchModal();
                }
            };
        });
    </script>

    {{-- <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Muestra el popup después de que la página se ha cargado completamente
            document.getElementById("popup").style.display = "block";
        });

        function closePopup() {
            // Oculta el popup cuando se hace clic en el botón de cerrar
            document.getElementById("popup").style.display = "none";
        }
    </script> --}}
    <!-- Botón de regreso al inicio -->
    <a href="" title="contador de visitas">
        <img src="https://counter11.optistats.ovh/private/contadorvisitasgratis.php?c=y37pn3f5quh2n62rdyjr2bulre9sy99r"
            title="contador de visitas com" alt="contadordevisitas.com">
    </a>

</body>

</html>
