<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <title>@yield('title') | Comité de Igualdad Laboral y No Discriminación</title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <meta name="description" content="@yield('meta-description', 'Página oficial del Comité de Igualdad Laboral y No Discriminación de la Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla. Promoviendo igualdad de oportunidades y derechos laborales.')">
    <meta name="keywords" content="@yield('keywords', 'Comité de Igualdad Laboral, No Discriminación, Secretaría de Planeación y Finanzas, Gobierno del Estado de Puebla, igualdad de oportunidades, derechos laborales, inclusión laboral, políticas de igualdad, equidad de género, diversidad laboral')">
    <meta name="author" content="Ing. Nery Pozos">
    <meta name="robots" content="index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1">
    <meta name="google" content="notranslate">
    <meta name="googlebot" content="index, follow">
    <meta name="google-site-verification" content="G-XY18X19KGL">
    <meta name="bingbot" content="index, follow">
    <meta name="referrer" content="no-referrer-when-downgrade">
    <meta name="format-detection" content="telephone=no">
    <meta name="HandheldFriendly" content="True">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="theme-color" content="#ab6157">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta property="og:title" content="@yield('og-title', 'Comité de Igualdad Laboral y No Discriminación - Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla')">
    <meta property="og:description" content="@yield('og-description', 'Página informativa del Comité de Igualdad Laboral y No Discriminación de la Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla')">
    <meta property="og:type" content="website">
    <meta property="og:url" content="@yield('og:url', 'https://comiteigualdadlaboralspf.puebla.gob.mx')">
    <meta property="og:image" content="@yield('og:image', 'https://comiteigualdadlaboralspf.puebla.gob.mx/imagenes/carrusel-inicio/1.jpg')">
    <meta property="og:site_name" content="@yield('og:site_name', 'Comité de Igualdad Laboral y No Discriminación de la Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla')">
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="@yield('twitter-title', 'Comité de Igualdad Laboral y No Discriminación de la Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla')">
    <meta name="twitter:description" content="@yield('twitter-description', 'Página Informativa del Comité de Igualdad Laboral y No Discriminación de la Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla')">
    <meta name="twitter:image" content="@yield('twitter:image', 'https://comiteigualdadlaboralspf.puebla.gob.mx/imagenes/carrusel-inicio/1.jpg')">
    <link rel="canonical" href="@yield('canonical-url', 'https://comiteigualdadlaboralspf.puebla.gob.mx')">

    <!-- Favicon -->
    <link href="{{ asset('imagenes/favicon.png') }}" rel="icon" />

    @yield('page_css')
    <script src="{{ asset('js/sienna.min.js') }}" defer></script>

    <!-- Librerías de hojas de estilo de Owl Carousel -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.css"
        integrity="sha512-UTNP5BXLIptsaj5WdKFrkFov94lDx+eBvbKyoe1YAfjeRPC+gT5kyZ10kOHCfNZqEui1sxmqvodNUx3KbuYI/A=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css"
        integrity="sha512-sMXtMNL1zRzolHYKEujM2AqCLUR9F2C4/05cdbxjjLSRvMQIciEPCQZo++nk7go3BtSuK9kfa/s+a4f4i5pLkw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- Librerias de AOS -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet" />

    <!-- Hojas de estilos de Bootstrap  -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous" />
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-ka7Sk0Gln4gmtz2MlQnikT1wXgYsOg+OMhuP+IlRH9sENBO0LRn5q+8nbTov4+1p" crossorigin="anonymous">
    </script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet" />

    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css"
        integrity="sha512-..................." crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- CSS de la Página-->
    <link rel="stylesheet" href="{{ asset('css/estilos.css') }}?v={{ rand() }}">

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    @yield('page_css')
    @yield('jss-inicial')
    @yield('css')
</head>

<body>
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-KH1F0SWYQB"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());

        gtag('config', 'G-KH1F0SWYQB');
    </script>
    {{-- <div class="popup-container" id="popup">
        <div class="popup-content">
            <h4>Aviso</h4>
            <p>
                En apego a las acciones preventivas implementadas por la
                Administración Pública Estatal, con motivo del Proceso Electoral 2024,
                este contenido será modificado temporalmente en atención a las
                disposiciones legales y normativas en material electoral.
            </p>
            <button class="enterado-btn" onclick="closePopup()">Enterado</button>
        </div>
    </div> --}}
    <div id="thetop" class="thetop"></div>
    <div class='backtotop'>
        <a href="#thetop" class='scroll'>
            <i class="fas fa-angle-double-up"></i>
        </a>
    </div>

    <div class="loader-section">
        <span class="loader"></span>
    </div>
    <div class="floating-button">
        <button id="openPdfModalBtn" class="btn btn-floating">
            <img src="{{ asset('imagenes/medalla.png') }}" alt="Medalla de Oro">
        </button>
    </div>
    <div class="wrapper">
        @auth
            <nav class="navbar navbar-expand-md navbar-light bg-white shadow-sm">
                <div class="container">
                    <a class="navbar-brand" href="{{ url('/') }}">
                        {{ config('Comité de Igualdad Laboral y No Discriminación', 'Comité de Igualdad Laboral y No Discriminación') }}
                    </a>
                    <button class="navbar-toggler" type="button" data-toggle="collapse"
                        data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                        aria-expanded="false" aria-label="{{ __('Toggle navigation') }}">
                        <span class="navbar-toggler-icon"></span>
                    </button>

                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <!-- Left Side Of Navbar -->
                        <ul class="navbar-nav mr-auto">
                        </ul>
                        <!-- Right Side Of Navbar -->
                        <ul class="navbar-nav ml-auto">
                            <!-- Authentication Links -->
                            @guest
                                @if (Route::has('login'))
                                    <li class="nav-item">
                                        <a class="nav-link" href="{{ route('login') }}">{{ __('Login') }}</a>
                                    </li>
                                @endif

                                @if (Route::has('register'))
                                    <li class="nav-item">
                                        <a class="nav-link" href="{{ route('register') }}">{{ __('Register') }}</a>
                                    </li>
                                @endif
                            @else
                                <li class="nav-item dropdown">
                                    <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button"
                                        data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                                        {{ Auth::user()->name }}
                                    </a>

                                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                                        <a class="dropdown-item" href="{{ route('dashboard') }}">
                                            {{ __('Panel') }}
                                        </a>
                                        <a class="dropdown-item" href="{{ route('logout') }}"
                                            onclick="event.preventDefault();
                                                                    document.getElementById('logout-form').submit();">
                                            {{ __('Logout') }}
                                        </a>

                                        <form id="logout-form" action="{{ route('logout') }}" method="POST"
                                            class="d-none">
                                            @csrf
                                        </form>
                                    </div>
                                </li>
                            @endguest
                        </ul>
                    </div>
                </div>
            </nav>
        @endauth

        <main class="">
            @yield('content')
        </main>

    </div>
    <!-- Modal para el PDF -->
    <div id="pdfModalUnique" class="modal unique-modal">
        <div class="modal-content">
            <span class="close" id="closeCertificacion">&times;</span>
            <iframe style="height: 100%"
                src="https://comiteigualdadlaboralspf.puebla.gob.mx/documentos/tecnicos/Certificado.pdf
"></iframe>
        </div>
    </div>


    @yield('scripts')
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.bundle.min.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"
        integrity="sha512-bPs7Ae6pVvhOSiIcyUClR7/q2OAsRiovw4vAkX+zJbw3ShAeeqezq50RIIcIURq7Oa20rW2n2q+fyXBNcU9lrw=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
        function pageLoaded() {
            let loaderSection = document.querySelector(".loader-section");
            loaderSection.classList.add("loaded");
        }
        document.onload = pageLoaded();
    </script>
    <script>
        // Abrir modal al hacer clic en el botón flotante
        document.getElementById('openPdfModalBtn').addEventListener('click', function() {
            document.getElementById('pdfModalUnique').style.display = 'block';
        });
        // Cerrar modal al hacer clic en el botón de cerrar o fuera del modal
        document.getElementById('closeCertificacion').addEventListener('click', function() {
            document.getElementById('pdfModalUnique').style.display = 'none';
        });

        window.addEventListener('click', function(event) {
            var modal = document.getElementById('pdfModalUnique');
            if (event.target === modal) {
                modal.style.display = 'none';
            }
        });
    </script>
    {{-- <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Muestra el popup después de que la página se ha cargado completamente
            document.getElementById("popup").style.display = "block";
        });

        function closePopup() {
            // Oculta el popup cuando se hace clic en el botón de cerrar
            document.getElementById("popup").style.display = "none";
        }
    </script> --}}
    <!-- Botón de regreso al inicio -->
    <a aria-label="Botón de vuelta al inicio" href="#"
        class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>
    <a href="" title="contador de visitas"><img
            src="https://counter11.optistats.ovh/private/contadorvisitasgratis.php?c=y37pn3f5quh2n62rdyjr2bulre9sy99r"
            border="0" title="contador de visitas com" alt="contador de visitas com"></a>

</body>

</html>
