function pageLoaded() {
    let loaderSection = document.querySelector(".loader-section");
    loaderSection.classList.add("loaded");
}
document.onload = pageLoaded();
window.addEventListener("load", function () {
    let modal = document.getElementById("customSearchModal");

    window.openSearchModal = function () {
        modal.classList.add("show");
    };

    window.closeSearchModal = function () {
        modal.classList.remove("show");
    };

    window.onclick = function (event) {
        if (event.target === modal) {
            closeSearchModal();
        }
    };
});

const navbar = document.getElementById("navbar");
const navbarMovil = document.getElementById("movil-navbar");
let lastScrollTop = 0;

window.addEventListener("scroll", () => {
    const currentScroll = window.pageYOffset;

    if (currentScroll > 50) {
        // Aplica la clase sticky cuando se desplaza hacia abajo o arriba
        navbar.classList.add("sticky");
    } else {
        // Remueve la clase sticky cuando vuelve a la parte superior
        navbar.classList.remove("sticky");
    }

    lastScrollTop = currentScroll;
});

document.addEventListener("DOMContentLoaded", function () {
    const menuButton = document.getElementById("menuButton");
    const menuOverlay = document.getElementById("menuOverlay");
    const mobileMenu = document.getElementById("mobileMenu");

    menuButton.addEventListener("click", function () {
        mobileMenu.classList.add("active");
        menuOverlay.classList.add("active");
    });

    menuOverlay.addEventListener("click", function () {
        mobileMenu.classList.remove("active");
        menuOverlay.classList.remove("active");
    });
});
