<?php

namespace App\Providers;

use Illuminate\Support\Facades\Gate;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Date;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Date::setLocale('es');
        Schema::defaultStringLength(191);
        Gate::before(function ($user, $ability) {
            return $user->email == 'admin-comite-igualdad@puebla.gob.mx' ?? null;
        });
        if (config('app.env') === 'production') {
            \URL::forceScheme('https');
        }

        //
    }
}
