<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class Evento extends Model
{
    use HasFactory;
    protected $fillable = ['titulo', 'descripcion', 'fecha_evento', 'dia', 'dia_semana', 'mes_anio', 'subtitulo'];

    public function setFechaEventoAttribute($value)
    {
        $this->attributes['fecha_evento'] = $value;
        $date = Carbon::parse($value);

        $this->attributes['dia'] = $date->day;
        $this->attributes['dia_semana'] = $date->locale('es')->isoFormat('dddd');
        $this->attributes['mes_anio'] = $date->locale('es')->isoFormat('MMMM YYYY');
    }
}
