<?php

namespace App\Http\Controllers;

use App\Models\Queja;
use Illuminate\Http\Request;

class QuejaController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:ver-queja', ['only' => ['index']]);
        $this->middleware('permission:borrar-queja', ['only' => ['destroy']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $quejas = Queja::all();
        return view('panel-quejas.index', compact('quejas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // Validar los datos del formulario
        $request->validate([
            'nombre' => 'required|string',
            'correo' => 'required|email',
            'telefono' => 'required|string|max:15',
            'tipo_discriminacion' => 'required',
            'queja' => 'required',
            'formato' => 'required|mimes:pdf,docx',
            'g-recaptcha-response' => 'required|captcha'
        ], [
            'nombre.required' => 'El nombre de la persona es requerido',
            'nombre.string' => 'El nombre no puede contener números',
            'correo.required' => 'Se requiere un correo electrónico de contacto',
            'correo.email' => 'El dato ingresado no cumple con las características de un correo',
            'telefono.required' => 'Se requiere un número de teléfono de contacto',
            'telefono.string' => 'El número no puede contener más de 15 dígitos',
            'telefono.max' => 'El número no puede contener más de 15 dígitos',
            'tipo_discriminacion.required' => 'Se requiere un tipo de queja',
            'queja.required' => 'Se requiere una descripción de lo sucedido',
            'formato.required' => 'No se ha cargado el formato correspondiente',
            'formato.mimes' => 'El archivo cargado no es PDF o Docx',
            'g-recaptcha-response.required' => 'Por favor, complete el captcha',
            'g-recaptcha-response.captcha' => 'Validación del captcha fallida, ¡intente nuevamente más tarde o contacte al administrador del sitio!'
        ]);


        $QuejaDiscriminacion = $request->all();
        if ($formato = $request->file('formato')) {
            $rutaGuardarDoc = 'incidentes/';
            $originalName = pathinfo($formato->getClientOriginalName(), PATHINFO_FILENAME);
            $FormatoQueja = $originalName . date('YmdHis') . "." . $formato->getClientOriginalExtension();

            $formato->move($rutaGuardarDoc, $FormatoQueja);
            $QuejaDiscriminacion['formato'] = "$FormatoQueja";
        }
        // Crear una nueva instancia del modelo Queja con los datos del formulario
        Queja::create($QuejaDiscriminacion);

        // Redirigir a la página de inicio o a donde lo desees después de guardar la queja
        // return redirect()->route('inicio.index')->with('success', '¡La queja se ha enviado exitosamente!');
        return redirect('/')->with('success', 'La queja se ha enviado correctamente');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Queja  $queja
     * @return \Illuminate\Http\Response
     */
    public function show(Queja $queja)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Queja  $queja
     * @return \Illuminate\Http\Response
     */
    public function edit(Queja $queja)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Queja  $queja
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Queja $queja)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Queja  $queja
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $mensaje = Queja::findOrFail($id);
        $mensaje->delete();
        return redirect()->route('panel-quejas.index')->with('success', 'Queja eliminada correctamente.');
    }
}
