<?php

namespace App\Http\Controllers;

use App\Models\Inicio;
use Illuminate\Http\Request;
use App\Models\Infografia;
use App\Models\Blog;
use Carbon\Carbon;

class InicioController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $fechaActual = \Carbon\Carbon::now();

        $tipos_discriminacion = ['De género', 'Laboral'];
        $infografias = Infografia::where(function ($query) use ($fechaActual) {
            $query->where('fecha_publicacion', '<=', $fechaActual)
                ->orWhereNull('fecha_publicacion'); // Incluye registros sin fecha_publicacion
        })
            ->orderBy('anio', 'desc')
            ->orderBy('created_at', 'desc')
            ->take(5)
            ->get();

            $blogs = Blog::where('is_published', 1)
            ->whereDate('published_at', '<=', now())
            ->orderBy('published_at', 'desc')
            ->orderBy('created_at', 'desc')
            ->take(4)
            ->get();

        return view('inicio', compact('tipos_discriminacion', 'infografias', 'blogs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Inicio  $inicio
     * @return \Illuminate\Http\Response
     */
    public function show(Inicio $inicio)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Inicio  $inicio
     * @return \Illuminate\Http\Response
     */
    public function edit(Inicio $inicio)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Inicio  $inicio
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Inicio $inicio)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Inicio  $inicio
     * @return \Illuminate\Http\Response
     */
    public function destroy(Inicio $inicio)
    {
        //
    }
}
